/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: SaxonXQueryAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.18 $
 * Last Modified: $Date: 2008/03/25 11:04:19 $
 *****************************************************************************/
package org.ten60.ura.xquery;

import com.ten60.netkernel.urii.IURAspect;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.util.PairList;

import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;
import org.ten60.netkernel.layer1.representation.StringAspect;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier.CompoundURIStruct;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.xml.util.NKFURIResolver;

import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;

/** <p>A URA to access Michael Kays Saxon implementation of the W3C XQuery 1.0
 * language.
 * </p>
 * @author pjr
 */
public class SaxonXQueryAccessor extends NKFAccessorImpl
{
	/** Creates a new instance of SaxonXqueryAccessor */
	public SaxonXQueryAccessor()
	{	super(2, true, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	XQueryAspect xqa = (XQueryAspect)context.sourceAspect("this:param:operator", XQueryAspect.class);
		
		URRequest req=context.getKernelHelper().getThisKernelRequest();
		CompoundURIdentifier curi=new CompoundURIdentifier(req.getURI());
	
		Iterator i=curi.getArgs();
		PairList params = new PairList(1);
		URIResolver resolver =  new NKFURIResolver(context);
		while(i.hasNext())
		{	CompoundURIStruct struct=(CompoundURIStruct)i.next();
			if(!struct.getKey().equals("operator"))
			{	params.put(struct.getKey(), resolver.resolve(struct.getURI(),null) );
			}		
		}
		StringWriter sw = new StringWriter(256);
		StreamResult sr = new StreamResult(sw);
		synchronized(xqa)
		{	xqa.evaluateQuery(sr, context, resolver, params);
		}
		
		IURAspect aspect = new StringAspect(sw.toString());
		INKFResponse resp=context.createResponseFrom(aspect);
		resp.setMimeType("text/xml");
		context.setResponse(resp);
	}	
}
