/******************************************************************************
 * (c) Copyright 2002-2004, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: XPath2EvalAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.8 $
 * Last Modified: $Date: 2007/03/14 09:43:01 $
 *****************************************************************************/
package org.ten60.ura.xpath2;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectBoolean;
import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import java.util.*;

import net.sf.saxon.sxpath.*;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.Configuration;


import org.ten60.netkernel.layer1.representation.*;

/**
 * Evaluate an XPath 2.0 expression and return result as a boolean document
 * @author  pjr
 */
public class XPath2EvalAccessor extends NKFAccessorImpl
{
    /** Creates a new instance of XpathEvalAccessor */
    public XPath2EvalAccessor()
    {   super(4, true, INKFRequestReadOnly.RQT_SOURCE);
    }
    
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	IXAspect optxa=(IXAspect)context.sourceAspect("this:param:operator", IXAspect.class);
		IXAspect opdxa=(IXAspect)context.sourceAspect("this:param:operand", IXAspect.class);
		IXDAReadOnly opt=optxa.getXDA();
		String xpathToEval=opt.getText(".",true);
		Configuration conf = new Configuration();
		XPathEvaluator xpe=new XPathEvaluator(conf);
		if(context.exists("this:param:namespace"))
		{	IXAspect nsxa=(IXAspect)context.sourceAspect("this:param:namespace", IXAspect.class);
			xpe.setNamespaceResolver(new NamespaceResolverImpl(nsxa.getXDA()));
			if(nsxa.getXDA().isTrue("/namespace/default"))
			{	String defaultns=nsxa.getXDA().getText("/namespace/default",true);
				xpe.setDefaultElementNamespace(defaultns);
			}
		}
		boolean b = xpe.createExpression(xpathToEval).evaluateSingle(new DocumentWrapper(opdxa.getReadOnlyDocument(), context.getThisRequest().getArgument("operand"), conf))!=null;
		IURAspect aspect=new BooleanAspect(b);
		context.createResponseFrom(aspect);
	}
	
}

class NamespaceResolverImpl implements NamespaceResolver
{	private Map mMap;	
	
	public NamespaceResolverImpl(IXDAReadOnly doc) throws Exception
	{	if(!doc.isTrue("/namespace")) throw new Exception("namespaces declaration does not have <namespace> root element");
		mMap=new HashMap();
		if(doc.isTrue("/namespace/default"))
		{	mMap.put("",doc.getText("/namespace/default",true));
		}
		IXDAReadOnlyIterator it=doc.readOnlyIterator("/namespace/entry");
		while(it.hasNext())
		{	it.next();
			String prefix=it.getText("prefix", true);
			String uri=it.getText("uri", true);
			mMap.put(prefix,uri);
		}
	}
	
	public String getURIForPrefix(String str, boolean param)
	{	if(!param && str.equals(""))
		{	return "";
		}
		return (String)mMap.get(str);
	}
	
	public java.util.Iterator iteratePrefixes()
	{	return mMap.keySet().iterator();
	}
	
}
