/*
 * ValidateSchematron2Accessor.java
 *
 * Created on 30 May 2006, 09:06
 */

package org.ten60.ura.schematron;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import com.ten60.netkernel.urii.*;

/**
 *
 * @author  pjr
 */
public class ValidateSchematron2Accessor extends NKFAccessorImpl
{
	
	/** Creates a new instance of ValidateSchematron2Accessor */
	public ValidateSchematron2Accessor()
	{	super(4, SAFE_FOR_CONCURRENT_USE, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	String op=context.getThisRequest().getArgument("operator");
		context.setCWU(new String("ffcpl:/org/ten60/ura/schematron/"));
		//Build validator - attempt to use epxlicit URI to ensure validator caching
		INKFRequest req=context.createSubRequest("active:xslt");
		req.addArgument("operator","conformance1-5.xsl");
		if(op.startsWith("ffcpl"))
		{	req.addArgument("operand",op);			
		}
		else
		{	req.addArgument("operand", context.source("this:param:operator"));
		}
		IURRepresentation rep=context.issueSubRequest(req);
		
		//Perform validation
		req=context.createSubRequest("active:xslt2");
		req.addArgument("operator", rep);
		req.addArgument("operand", context.source("this:param:operand"));
		rep=context.issueSubRequest(req);
		
		//Convert to Canonical Boolean
		req=context.createSubRequest("active:xslt");
		req.addArgument("operator", "toBoolean.xsl");
		req.addArgument("operand", rep);
		rep=context.issueSubRequest(req);
		
		INKFResponse resp=context.createResponseFrom(rep);
		resp.setMimeType("text/xml");
	}
	
}
