/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: URIQueryAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2004/08/12 11:40:30 $
 *****************************************************************************/
package org.ten60.ura.util;

import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.accessor.*;

import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urii.aspect.IAspectBoolean;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.urii.aspect.IAspectString;

import java.net.*;
import java.util.*;
import java.io.*;

/**
 *  Accessor to implement conversions between URI's with queries, NVP and x-www-form-urlencoded
 * data
 * @author  tab
 */
public class URIQueryAccessor extends ActiveAccessorImpl
{
	/** Creates a new instance of ExistsAccessor */
	public URIQueryAccessor()
	{	super(4,true);
	}
	
	public void requestAsync(URRequest aRequest)
	{	try
		{	CompoundURIdentifier uri = new CompoundURIdentifier(aRequest.getURI());
			String type = uri.getType();
			IURRepresentation result;
			if (type.equals("getURIQuery"))
			{	result = getURIQuery(aRequest,uri);
			}
			else if (type.equals("setURIQuery"))
			{	result = setURIQuery(aRequest,uri);
			}
			else if (type.equals("formURIEncode"))
			{	result = formURIEncode(aRequest,uri);
			}
			else if (type.equals("formURIDecode"))
			{	result = formURIDecode(aRequest,uri);
			}
			else
			{	throw new NetKernelException("Unsupported Operation");
			}
			URResult r = new URResult(aRequest,result);
			getScheduler().receiveAsyncResult(r);
		}
		catch (Throwable e)
		{	NetKernelException nke = new NetKernelException("Unhandled Exception in Accessor");
			nke.addCause(e);
			URResult result = new URResult(aRequest,NetKernelExceptionAspect.create(nke));
			getScheduler().receiveAsyncException(result);
		}
	}
	
	private IURRepresentation getURIQuery(URRequest aRequest, CompoundURIdentifier aURI) throws Throwable
	{	IURRepresentation rep;
		URI operand = URI.create(aURI.get(CompoundURIdentifier.OPERAND));
		String query = operand.getRawQuery();
		if (query!=null)
		{	IAspectNVP nvp = queryToNVP(query);
			IURMeta meta = new TimedExpiryMeta("application/x-www-form-urlencoded", TimedExpiryMeta.ONE_DAY, 4);
			rep = new MonoRepresentationImpl(meta,nvp);
		}
		else
		{	rep = VoidAspect.create();
		}
		return rep;
	}
	
	private IURRepresentation setURIQuery(URRequest aRequest, CompoundURIdentifier aURI) throws Throwable
	{	URI operand = URI.create(aURI.get(CompoundURIdentifier.OPERAND));
		URIdentifier param = new URIdentifier(aURI.get(CompoundURIdentifier.PARAM));
		IURRepresentation paramRep = this.getResource(param, IAspectNVP.class, aRequest);
		IAspectNVP paramNVP =(IAspectNVP)paramRep.getAspect(IAspectNVP.class);
		String query = NVPToQuery(paramNVP);
		if (query.length()==0) query=null;
		URI withQuery = new URI(operand.getScheme(),operand.getAuthority(),operand.getPath(),query,operand.getFragment());
		DependencyMeta dm = new DependencyMeta("application/uri", 4, 0);
		dm.addDependency(paramRep);
		IURAspect aspect = new URIAspect(withQuery);
		return new MonoRepresentationImpl(dm, aspect);
	}
	
	private IURRepresentation formURIEncode(URRequest aRequest, CompoundURIdentifier aURI) throws Throwable
	{	URIdentifier operand = new URIdentifier(aURI.get(CompoundURIdentifier.OPERAND));
		IURRepresentation operandRep = this.getResource(operand, IAspectNVP.class, aRequest);
		IAspectNVP operandNVP =(IAspectNVP)operandRep.getAspect(IAspectNVP.class);
		String query = NVPToQuery(operandNVP);
		DependencyMeta dm = new DependencyMeta("application/x-www-form-urlencoded", 4, 0);
		dm.addDependency(operandRep);
		IURAspect aspect = new StringAspect(query);
		return new MonoRepresentationImpl(dm, aspect);
	}
	
	private IURRepresentation formURIDecode(URRequest aRequest, CompoundURIdentifier aURI) throws Exception
	{	URIdentifier operand = new URIdentifier(aURI.get(CompoundURIdentifier.OPERAND));
		IURRepresentation operandRep = this.getResource(operand, IAspectString.class, aRequest);
		String operandString =((IAspectString)operandRep.getAspect(IAspectString.class)).getString();
		IAspectNVP query = queryToNVP(operandString);
		DependencyMeta dm=new DependencyMeta("text/nvp", 4, 0);
		dm.addDependency(operandRep);
		return new MonoRepresentationImpl(dm, query);
	}
	
	private IAspectNVP queryToNVP(String aQuery) throws UnsupportedEncodingException
	{	NVPImpl nvp = new NVPImpl();
		StringTokenizer st=new StringTokenizer(aQuery,"&=");
		while (st.hasMoreTokens())
		{	String key = st.nextToken();
			String value = URLDecoder.decode(st.nextToken(),"UTF-8");
			nvp.addNVP(key,value);
		}
		return new NVPAspect(nvp);
	}
	
	private String NVPToQuery(IAspectNVP aNVP) throws UnsupportedEncodingException
	{	StringBuffer sb=new StringBuffer(128);
		boolean notFirstTime=false;
		for (Iterator i = aNVP.getNames().iterator(); i.hasNext(); )
		{	if (notFirstTime)
			{	sb.append('&');
			}
			else
			{	notFirstTime=true;
			}

			String name=(String)i.next();
			for (Iterator j = aNVP.getValues(name).iterator(); j.hasNext(); )
			{	String value = (String)j.next();
				sb.append(name);
				sb.append('=');
				sb.append(URLEncoder.encode(value,"UTF-8"));
			}
		}
		return new String(sb);
	}
}