/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: RequestWithArgsAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2004/08/12 11:40:31 $
 *****************************************************************************/
package org.ten60.ura.sys;

import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import org.ten60.netkernel.layer1.util.*;
import org.ten60.netkernel.layer1.accessor.*;

import java.util.*;

/**
 * This Accessor issues a request to the URI specified as the "uri" argument with
 * all arguments appended.  Can be used from DPML to call any URI interface and not just
 * active URI's, may have value with rewrite rules.
 * @author  pjr
 */
public class RequestWithArgsAccessor extends ActiveAccessorImpl
{
	public static final String URI_ARGUMENT="uri";
	
	/** Creates a new instance of RequestWithArgsAccessor */
	public RequestWithArgsAccessor()
	{	super(4, true);
	}
	
	public void requestAsync(com.ten60.netkernel.urrequest.URRequest aRequest)
	{	boolean error=false;
		IURRepresentation result=null;
		try
		{
			if(aRequest.getType()!=URRequest.RQT_SOURCE) throw new Exception("Only support source");
			result=source(aRequest);
		}
		catch(Throwable e)
		{	error=true;
			NetKernelException nke=new NetKernelException("Problem in RequestWithArgs");
			nke.addCause(e);
			result=NetKernelExceptionAspect.create(nke);
		}
		URResult res=new URResult(aRequest,result);
		if(error) getScheduler().receiveAsyncException(res);
		else getScheduler().receiveAsyncResult(res);
	}
	
	private IURRepresentation source(URRequest aRequest) throws Exception
	{	CompoundURIdentifier curi=new CompoundURIdentifier(aRequest.getURI());
		String uri=curi.get(URI_ARGUMENT);
		if(uri==null) throw new Exception("Must provide 'uri@....' argument");
		
		CompoundURIdentifier innerURI=new CompoundURIdentifier(new URIdentifier(uri));
		Iterator it=curi.getArgs();
		if(!curi.getType().equals("requestWithAnonymousArgs")){
			while(it.hasNext())
			{	CompoundURIdentifier.CompoundURIStruct struct=(CompoundURIdentifier.CompoundURIStruct)it.next();
				if(!struct.getKey().equals(URI_ARGUMENT))
				{	innerURI.addArg(struct.getKey(), struct.getURI());
				}
			}
		}
		URRequest inner=new URRequest(innerURI.toURI(), this, aRequest.getSession(), aRequest.getContext(), URRequest.RQT_SOURCE, aRequest.getCWU(), aRequest, IURAspect.class);
		Collection args=aRequest.getArgs();
		Iterator i=args.iterator();
		while(i.hasNext())
		{	URIdentifier arguri=(URIdentifier)i.next();
			inner.addArg(arguri, aRequest.getArg(arguri));
		}
		
		return getScheduler().requestSynch(inner).getResource();
	}
	
}
