/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: FLSAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.1 $
 * Last Modified: $Date: 2004/08/12 08:42:23 $
 *****************************************************************************/
package org.ten60.ura.sys;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.XMLUtils;

import org.ten60.netkernel.layer1.meta.AlwaysExpiredMeta;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.module.*;

import java.util.*;
import java.util.regex.*;
import org.w3c.dom.*;

import java.io.*;
import java.net.*;

/**
 *
 * @author  tab
 */
public class FLSAccessor extends XAccessor
{
	public static final int LS_RECURSIVE=1;
	public static final int LS_SHOW_URI=4;
	public static final int LS_SHOW_MODULE=8;
	public static final int LS_SHOW_LENGTH=16;
	public static final int LS_SHOW_LAST_MODIFIED=32;
	public static final int LS_SHOW_AGE=64;
	
	private static final String NN_DIRECTORY="dir";
	private static final String NN_RESOURCE="res";
	
	public FLSAccessor()
	{	declareThreadSafe();
		declareArgument(XAccessor.OPERATOR, true, false);
	}
	
	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{
		IXDAReadOnly operator = aHelper.getOperator().getXDA();
		String root;
		File f=null;
		int flag = 0;
		if (operator.isTrue("recursive")) flag|=LS_RECURSIVE;
		if (operator.isTrue("uri")) flag|=LS_SHOW_URI;
		if (!operator.isTrue("root")) throw new Exception("Must declare root directory in element <root>");
		else
		{	root=operator.getText("/fls/root",true);
			f=new File(URI.create(root));
			if(!f.isDirectory()) throw new Exception("Root must be directory");
		}
					
 		if (operator.isTrue("length")) flag|=LS_SHOW_LENGTH;
		if (operator.isTrue("lastmodified")) flag|=LS_SHOW_LAST_MODIFIED;
		if (operator.isTrue("age")) flag|=LS_SHOW_AGE;
		Matcher filter = null;
		if (operator.isTrue("filter"))
		{	String filterRegex = operator.getText("filter",true);
			filter = Pattern.compile(filterRegex).matcher("");
		}
		
		Document d = listResources(root,f,flag,filter);

		DOMXDA xda = new DOMXDA(d,false);
		return DOMXDAAspect.create(new AlwaysExpiredMeta("text/xml", 64), xda);
	}
	
	public Document listResources(String aRoot, File f,int aFlags, Matcher aFilter) throws Exception
	{	Document d = XMLUtils.newDocument();
		Element root = d.createElement("fls");
		d.appendChild(root);
		StringBuffer path = new StringBuffer(256);
		path.append(aRoot);
		recurseDir(f,root,path,false, aFlags, aFilter);
		
		return d;
	}
	
	private int recurseDir(File aFile, Node aNode, StringBuffer aPath, boolean aExternal, int aFlags, Matcher aFilter) throws Exception
	{	int count=0;
		long time = System.currentTimeMillis();
		File[] files = aFile.listFiles();
		if (files == null) return 0;
		int pathLength = aPath.length();
		for (int i=0; i<files.length; i++)
		{	File f = files[i];
			String name = f.getName();
			boolean isDirectory = f.isDirectory();
			aPath.setLength(pathLength);
			if (isDirectory)
			{	aPath.append(name);
				aPath.append('/');
				//String path = aPath+name+'/';
				Node child = ensureChild(aNode,name,isDirectory,false);
				int recurseCount=0;
				if((aFlags&LS_RECURSIVE)>0) recurseCount=recurseDir(f,child,aPath,aExternal,aFlags,aFilter);
				if (recurseCount>0)
				{	count+=recurseCount;
				}
				else
				{	if (XMLUtils.getFirstChildElement(child)==null)
					{	aNode.removeChild(child);
					}
				}
			}
			else
			{	aPath.append(name);
				//String path = aPathaBuffer.toString();
				boolean unfiltered = true;
				if (aFilter!=null)
				{	aFilter.reset(aPath);
					unfiltered = aFilter.matches();
				}
				if (unfiltered)
				{	if (!aExternal)
					{	Node child = ensureChild(aNode,name,isDirectory,true);
						if (child!=null)
						{	count++;
							if ((aFlags&LS_SHOW_URI)>0)
								XMLUtils.appendTextedElement(child, "uri", escape(aPath.toString()));
							if ((aFlags&LS_SHOW_LENGTH)>0)
								XMLUtils.appendTextedElement(child, "length", Long.toString(f.length()));
							if ((aFlags&LS_SHOW_LAST_MODIFIED)>0)
								XMLUtils.appendTextedElement(child, "lastmodified", Long.toString(f.lastModified()));
							if ((aFlags&LS_SHOW_AGE)>0)
								XMLUtils.appendTextedElement(child, "age", Long.toString(time-f.lastModified()));
						}
					}
				}
			}
		}
		return count;
	}
	
	private String escape(String aString)
	{	return aString.replaceAll(" ", "%20");
	}
	
	private static Node ensureChild(Node aParent, String aName, boolean aIsDirectory, boolean aMustCreate) throws Exception
	{	Node result = null;
		String name = aIsDirectory?NN_DIRECTORY:NN_RESOURCE;
		for (Node n = aParent.getFirstChild(); n!=null; n=n.getNextSibling())
		{	if (n.getNodeName().equals(name))
			{	String childName = XMLUtils.getText(n);
				if (childName.equals(aName))
				{	result = n;
					break;
				}
			}
		}
		if (result==null)
		{	Element e = aParent.getOwnerDocument().createElement(name);
			XMLUtils.setText(e, aName);
			aParent.appendChild(e);
			result = e;
		}
		else if (aMustCreate)
		{	result = null;
		}
		
		return result;
	}
	
	private Node ensurePath(String aPath, Document aListingDoc) throws Exception
	{	StringTokenizer st=new StringTokenizer(aPath,"/");
		Node n = aListingDoc.getDocumentElement();
		while (st.hasMoreTokens())
		{	String childName = st.nextToken();
			boolean isDir = st.hasMoreTokens();
			n = ensureChild(n, childName, isDir, !isDir);
		}
		return n;
	}
}