/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ExpireAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2004/08/12 11:10:04 $
 *****************************************************************************/

package org.ten60.ura.sys;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.aspect.*;


import java.net.*;
import java.util.*;
/**
 * Casts a resource to another Mime/Type and Representational Form
 * @author  pjr
 */
public class ExpireAccessor extends XAccessor
{
	/** Creates a new instance of CastAccessor */
	public ExpireAccessor()
	{	declareArgument(OPERAND, true, false);
		declareArgument(OPERATOR, false, false);
		declareThreadSafe();
	}
	
	private static final String UNS_SECOND="second";
	private static final String UNS_MINUTE="minute";
	private static final String UNS_HOUR="hour";
	private static final String UNS_DAY="day";
	
	protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		long expiry;
		if (aHelper.hasOperator())
		{	IXDAReadOnly r=aHelper.getOperator().getXDA();
			String expiryUnitString=r.getText("/expire/unit", true);
			long multiplier;
			if (expiryUnitString.equals(UNS_SECOND))
			{	multiplier = TimedExpiryMeta.ONE_SECOND;
			}
			else if (expiryUnitString.equals(UNS_MINUTE))
			{	multiplier = TimedExpiryMeta.ONE_MINUTE;
			}
			else if (expiryUnitString.equals(UNS_HOUR))
			{	multiplier = TimedExpiryMeta.ONE_HOUR;
			}
			else if (expiryUnitString.equals(UNS_DAY))
			{	multiplier = TimedExpiryMeta.ONE_DAY;
			}
			else
			{	throw new NetKernelException("/expire/unit must be [second|minute|hour|day]");
			}
			String expiryValueString=r.getText("/expire/value", true);
			expiry = System.currentTimeMillis()+Long.parseLong(expiryValueString)*multiplier;
		}
		else
		{	// no operator default is to expire always
			expiry = 0;
		}
		
		IURRepresentation operand=aHelper.getOperand( IURAspect.class );
		return MirrorRepresentation.expire(operand, expiry);
	}

}
