/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: ExecProcessResponseAspect.java,v $
 * Version:       $Name:  $ $Revision: 1.5 $
 * Last Modified: $Date: 2004/10/29 10:38:34 $
 *****************************************************************************/
package org.ten60.ura.exec;

import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.representation.StringAspect;
import org.ten60.netkernel.layer1.util.Utils;
import java.io.*;
/**
 * An IAspectBinaryStream created by the execution of a exec-ed process.
 * The process is executed everytime its output is needed as its output
 * is not buffered but streamed.
 * @author  tab
 */
public class ExecProcessResponseAspect implements IAspectBinaryStream
{
	private String[] mCommand;
	private IAspectBinaryStream mStdinBinary;
	private String mStderrURI;
	private INKFConvenienceHelper mContext;
	private File mWd;
	private boolean mIgnoreReturnCode;
	
	/** Creates a new instance of ExecProcessResponseAspect */
	public ExecProcessResponseAspect(String[] aCommand, IAspectBinaryStream aStdinBinary, String aStderrURI, File aWd, boolean aIgnoreReturnCode, INKFConvenienceHelper aContext)
	{	mCommand = aCommand;
		mStdinBinary=aStdinBinary;
		if (aStderrURI!=null)
		{	mStderrURI=aStderrURI;
			mContext=aContext;
		}
		mWd=aWd;
		mIgnoreReturnCode=aIgnoreReturnCode;
	}
	
	public String getEncoding()
	{	return null;
	}
	
	public void write(OutputStream aStream) throws IOException
	{	try
		{	Process p = Runtime.getRuntime().exec(mCommand,null,mWd);

			// connect stdin - needs feeder thread
			StdinFeederThread t=null;
			if (mStdinBinary!=null)
			{	t = new StdinFeederThread(p.getOutputStream());
				t.start();
			}

			// connect stdout
			Utils.pipe(p.getInputStream(), aStream);

			// connect stderr to handler
			INKFAsyncRequestHandle stderrHandlerHandle=null;
			if (mStderrURI!=null)
			{	ExecProcessStderrAspect aspect = new ExecProcessStderrAspect(p.getErrorStream());
				INKFRequest errorHandlerReq = mContext.createSubRequest();
				errorHandlerReq.setURI(mStderrURI);
				errorHandlerReq.addArgument("stderr",aspect);
				StringBuffer sb=new StringBuffer(128);
				for(int i=0; i<mCommand.length-1; i++)
				{	sb.append(mCommand[i]);
					sb.append(" ");
				}
				sb.append(mCommand[mCommand.length-1]);
				errorHandlerReq.addArgument("command",new StringAspect(sb.toString()));
				stderrHandlerHandle = mContext.issueAsyncSubRequest(errorHandlerReq);
			}

			// wait for completion and exit status
			int result=0;
			try
			{	result = p.waitFor();
				if (t!=null)
				{	t.join();
				}
				if (stderrHandlerHandle!=null)
				{	stderrHandlerHandle.join();
				}
			} catch (InterruptedException e)
			{ ; }
			if (t!=null && t.getException()!=null)
			{	IOException e = new IOException("Reading stdin failed for "+this.toString());
				e.initCause(t.getException());
				throw e;
			}
			if (!mIgnoreReturnCode && result!=0)
			{	throw new IOException("Non zero return code of "+result+" from "+this.toString());
			}
		}
		catch (NKFException e)
		{	IOException e2 = new IOException("Failed to initialise stderr handler for "+this.toString());
			e2.initCause(e);
			throw e2;
		}
	}
	
	public String toString()
	{	StringBuffer sb=new StringBuffer(128);
		sb.append("exec(\"");
		for (int i=0; i<mCommand.length; i++)
		{	sb.append(mCommand[i]);
			sb.append(" ");
		}
		sb.append("\")");
		return sb.toString();
	}
	
	private class StdinFeederThread extends Thread
	{	private OutputStream mStdin;
		private IOException mError;
		
		public StdinFeederThread(OutputStream aStdin)
		{	mStdin = aStdin;
		}
		
		public IOException getException()
		{	return mError;
		}
		
		public void run()
		{	try
			{	mStdinBinary.write(mStdin);
			}	catch (IOException e)
			{	mError = e;
			}
			finally
			{	try
				{	mStdin.flush();
					mStdin.close();
				} catch (IOException e)
				{	
				}
			}
		}
	}	
}