/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: ExecProcessAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2005/05/19 10:08:49 $
 *****************************************************************************/
package org.ten60.ura.exec;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.util.SysLogger;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.IXDAReadOnly;
import org.ten60.netkernel.xml.xda.IXDAReadOnlyIterator;
import java.io.*;
import java.net.URI;
import java.util.*;

/**
 * Wrap an external exec-ed process
 * @author  tab
 */
public class ExecProcessAccessor extends NKFAccessorImpl
{
	private static final String ARG_COMMAND="this:param:command";
	private static final String ARG_STDIN="this:param:stdin";
	private static final String ARG_PARAM="this:param:param";
	private static final String ARG_STDERR="stderr";
	private static final String ARG_WD="wd";
	
	/** Creates a new instance of AsyncJoinAccessor */
	public ExecProcessAccessor()                                                                  
	{	super(0,true,URRequest.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	String type = context.getThisRequest().getActiveType();
		if (type.equals("exec"))
		{	exec(context);
		}
		else if (type.equals("exec-stderr"))
		{	handleStderr(context);
		}
	}	
	
	private void exec(INKFConvenienceHelper context) throws Exception
	{	String[] command = getCommand(context);
		IAspectBinaryStream stdinBinary=getStdin(context);
		boolean ignoreReturnCode=false;
		boolean useDefaultStderrHandler=true;
		String mime="text/plain";
		if (context.getThisRequest().argumentExists("param"))
		{	IXDAReadOnly param = ((IAspectXDA)context.sourceAspect(ARG_PARAM,IAspectXDA.class)).getXDA();
			ignoreReturnCode= param.isTrue("//ignoreReturnCode");
			useDefaultStderrHandler= !param.isTrue("//ignoreStderr");
			if (param.isTrue("//mimetype"))
			{	mime=param.getText("//mimetype",true);
			}
		}
		String stderrURI=context.getThisRequest().getArgument(ARG_STDERR);
		if (stderrURI==null && useDefaultStderrHandler)
		{	stderrURI = "active:exec-stderr";
		}
		File wd = getWorkingDirectory(context);
		
		
		ExecProcessResponseAspect aspect = new ExecProcessResponseAspect(command,stdinBinary,stderrURI,wd,ignoreReturnCode,context);
		INKFResponse response = context.createResponseFrom(aspect);
		response.setMimeType(mime);
		response.setCreationCost(64);
		context.setResponse(response);
	}
	
	private String[] getCommand(INKFConvenienceHelper context) throws Exception
	{	IURRepresentation commandRep = context.source(ARG_COMMAND);
		String[] command;
		if (commandRep.hasAspect(IAspectXDA.class) || commandRep.hasAspect(IAspectNodeList.class) || commandRep.getMeta().getMimeType().equals("text/xml"))
		{	IXDAReadOnly commandXDA = ((IAspectXDA)context.sourceAspect(ARG_COMMAND,IAspectXDA.class)).getXDA();
			//StringBuffer commandBuffer=new StringBuffer(128);
			ArrayList al=new ArrayList(5);
			for (IXDAReadOnlyIterator i=commandXDA.readOnlyIterator("arg"); i.hasNext(); )
			{	i.next();
				al.add(i.getText(".",true));
			}
			command=new String[al.size()];
			for(int i=0; i< al.size(); i++ )
			{	command[i]=(String)al.get(i);
			}
		}
		else
		{	ByteArrayOutputStream baos=new ByteArrayOutputStream();
			((IAspectBinaryStream)context.sourceAspect(ARG_COMMAND,IAspectBinaryStream.class)).write(baos);
			String commandline=baos.toString();
			StringTokenizer st=new StringTokenizer(commandline, " ");
			int size=st.countTokens();
			command=new String[size];
			for(int i=0; i< size; i++ )
			{	command[i]=(String)st.nextToken();
			}
		}
		return command;
	}
	
	private IAspectBinaryStream getStdin(INKFConvenienceHelper context) throws Exception
	{	IAspectBinaryStream result=null;
		if (context.getThisRequest().argumentExists("stdin"))
		{	result = (IAspectBinaryStream)context.sourceAspect(ARG_STDIN, IAspectBinaryStream.class);
		}
		return result;
	}
	
	private File getWorkingDirectory(INKFConvenienceHelper context) throws Exception
	{	String wdURIString=context.getThisRequest().getArgument(ARG_WD);
		File wd=null;
		if (wdURIString!=null)
		{	URI wdURI = URI.create(wdURIString);
			if (!wdURI.getScheme().equals("file"))
			{	throw new NKFException("Working Directory invalid","working directory must be specified as a file: scheme URI",null);
			}
			else
			{	wd = new File(wdURI);
			}
		}
		return wd;
	}
	
	private void handleStderr(INKFConvenienceHelper context) throws Exception
	{	InputStream stream = ((IAspectReadableBinaryStream)context.sourceAspect("this:param:stderr",IAspectReadableBinaryStream.class)).getInputStream();
		String command = ((IAspectString)context.sourceAspect("this:param:command",IAspectString.class)).getString();
		BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
		String line;
		while ((line=reader.readLine())!=null)
		{   String message = "stderr from exec(\""+command+"\"): "+line;
			SysLogger.log(SysLogger.WARNING, this, message);
		}
	}
	
}