/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: JavaScriptImportCompiler.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2005/05/03 19:16:19 $
 *****************************************************************************/
package org.ten60.netkernel.script.transreptor;
import org.ten60.netkernel.script.engine.javascript.JavaScriptAspect;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFTransreptorImpl;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectReader;
import org.mozilla.javascript.*;
/**
 * Transreptor to take a raw script and produce a 
 * compiled script aspect for a dynamic import
 * @author  tab
 */
public class JavaScriptImportCompiler extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return JavaScriptAspect.class.isAssignableFrom(aTo);
	}
	
	public void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IAspectReader in=(IAspectReader)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,IAspectReader.class);
		Context ctx=Context.enter();
		try
		{   ctx.setOptimizationLevel(1);
			ctx.initStandardObjects();
			ctx.setCompileFunctionsWithDynamicScope(true);
			Script script = ctx.compileReader(in.getReader(), "", 1, null);
			IURAspect result = new JavaScriptAspect(script);
			INKFResponse response = context.createResponseFrom(result);
			response.setCreationCost(8);
			context.setResponse(response);
		}
		finally
		{   Context.exit();	    
		}
	}
	
}