/******************************************************************************
  (c) Copyright 2002-2005, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ScriptCompiler.java,v $
  Version:       $Name:  $ $Revision: 1.10 $
  Last Modified: $Date: 2004/10/06 10:25:56 $
 *****************************************************************************/

package org.ten60.netkernel.script.transreptor;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import org.mozilla.javascript.EvaluatorException;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFTransreptorImpl;

import org.ten60.netkernel.script.representation.IAspectE4X;

/**
 *
 * @author  pjr
 */
public class E4XSerializer extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return (aFrom.hasAspect(IAspectE4X.class)) 
			&& IAspectBinaryStream.class.isAssignableFrom(aTo);
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IURRepresentation aFrom = context.source(INKFRequestReadOnly.URI_SYSTEM, IAspectE4X.class);
		IAspectE4X e4xAspect = ((IAspectE4X)aFrom.getAspect(IAspectE4X.class));
		Object e4x=e4xAspect.getReadOnlyXML();
		StringAspect sa=new StringAspect(e4x.toString());
		
		INKFResponse resp=context.createResponseFrom(sa);
		resp.setMimeType(aFrom.getMeta().getMimeType());
		context.setResponse(resp);		
	}
	
	
}
