/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: GroovyEngine.java,v $
  Version:       $Name:  $ $Revision: 1.8 $
  Last Modified: $Date: 2004/09/30 11:08:52 $
 *****************************************************************************/
package org.ten60.netkernel.script.engine;

import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.urii.IURRepresentation;

import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;
import org.ten60.netkernel.script.representation.IScriptEngine;

import groovy.lang.*;
import org.codehaus.groovy.control.*;
import org.codehaus.groovy.control.messages.*;
import org.codehaus.groovy.runtime.*;
import java.io.*;
import java.util.*;

/**
 * Groovy script engine requiring a main method to aid efficiency
 * @author  tab
 */
public class GroovyEngine implements IScriptEngine
{  
	private Class mMainClass;
    
	public  void execute(INKFConvenienceHelper aContext, ClassLoader aClassLoader) throws Exception
	{	
		try
		{	Map m = new HashMap();
			m.put("context", aContext);
			Binding b =new Binding(m);
			Script s = InvokerHelper.createScript(mMainClass,b);
			s.run();
			
		} catch (com.ten60.netkernel.util.NetKernelError e)
		{	throw e;
		}
		catch (Error e)
		{	NetKernelException nke=new NetKernelException("Unhandled Error in Groovy");
			nke.addCause(e);
			throw nke;
		}
	}
	
	public void initialise(String aScript, INKFConvenienceHelper aContext, ClassLoader aClassLoader) throws Exception
	{	try
		{	GroovyClassLoader loader = new GroovyClassLoader(aClassLoader);
			mMainClass = loader.parseClass(aScript);
		}
		catch (CompilationFailedException e)
		{	
			ProcessingUnit unit=e.getUnit();
			NetKernelException nke=new NetKernelException("Failed to compile groovy","In phase "+unit.getPhaseDescription()+": "+e.toString(),null);
			for (int i=0; i<unit.getErrorCount(); i++)
			{	Message m = unit.getError(i);
				nke.addCause(unit.getException(i));
			}
			for (int i=0; i<unit.getWarningCount(); i++)
			{	WarningMessage m = unit.getWarning(i);
				SysLogger.log1(SysLogger.WARNING, this, "Warning issued compiling groovy script: %1", m.toString());
			}
			throw nke;
		}
		catch (com.ten60.netkernel.util.NetKernelError e)
		{	throw e;
		}
		catch (java.lang.Error e) // unfortunately these get thrown for non-critical reasons
		{	NetKernelException nke=new NetKernelException("Failed to compile groovy");
			nke.addCause(e);
			throw nke;
		}
	}
}