/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: NKFTransreptorImpl.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2004/09/01 15:51:44 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf.impl;

import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.scheduler.Scheduler;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.representation.ITransrepresentor;

import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;
/**
 * NKF based Transreptor implementation base class
 * @author  tab
 */
public abstract class NKFTransreptorImpl implements ITransrepresentor
{
	private ModuleDefinition mModule;
	private Container mContainer;
	private Scheduler mScheduler;
	
	/** Initialises the transreptor with hooks to its module
	 *@param aModule
	 *@param aContainer
	 */
	public final void init(ModuleDefinition aModule, Container aContainer)
	{	mModule=aModule;
		mContainer=aContainer;
	}
	
	private Scheduler getScheduler()
	{	if (mScheduler==null)
		{	mScheduler = (Scheduler)mContainer.getComponent(Scheduler.URI);
		}
		return mScheduler;
	}
	
	/** Adapts the kernel API into the NKF API and calls the 
	 *transrepresent(INKFConvenienceHelper context) method.
	 *@param aFrom
	 *@param aRequest
	 *@exception NetKernelException
	 */
	public final IURRepresentation transrepresent(IURRepresentation aFrom, URRequest aRequest) throws NetKernelException
	{	try
		{	Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
			NKFHelperImpl context = new NKFTransreptorHelperImpl(mContainer,mModule,getScheduler(),aRequest);
			transrepresent(context);
			IURRepresentation result = context.getResponse();
			return result;
		}
		catch (Exception e)
		{	NetKernelException nke=new NetKernelException("Unhandled Exception in Transreptor","Unhandled exception thrown by "+this.getClass().toString(),null);
			nke.addCause(e);
			throw nke;
		}
	}	
	
	/** Implement this method to provide the resultant representation on the response
	 * @param context the full NKF context for the request
	 * @exception Exception you can throw any exception you like and it will be mapped
	 * into a NetKernelException
	 */
	protected abstract void transrepresent(INKFConvenienceHelper context) throws Exception;
}