/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: NKFRequestReadOnlyImpl.java,v $
 * Version:       $Name:  $ $Revision: 1.10 $
 * Last Modified: $Date: 2004/10/06 10:40:56 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf.impl;

import org.ten60.netkernel.layer1.nkf.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import java.net.URI;
import java.util.*;
/**
 * Wrapper around the request that initiated the invocation of the accessor
 * @author  tab
 */
public class NKFRequestReadOnlyImpl implements INKFRequestReadOnly
{
	private URRequest mRequest;
	private CompoundURIdentifier mActive;
	
	/** Creates a new instance of NKFRequestReadOnlyImpl */
	public NKFRequestReadOnlyImpl(URRequest aRequest)
	{	mRequest = aRequest;
		if (CompoundURIdentifier.isCompound(aRequest.getURI()) || aRequest.getURI().getScheme().equals("active"))
		{	mActive = new CompoundURIdentifier(aRequest.getURI());
		}
	}
	
	URRequest getKernelRequest()
	{	return mRequest;
	}
	
	public Class getAspectClass()
	{	return mRequest.getAspectClass();
	}
	
	public String getCWU()
	{	URIdentifier cwu=mRequest.getCWU();
		return cwu!=null ? cwu.toString(): null;
	}
	
	public int getRequestType()
	{	return mRequest.getType();
	}
	
	public String getURI()
	{	return mRequest.getURI().toString();
	}
	
	public String getFragment()
	{	String uri = getURI();
		String result;
		int i=uri.lastIndexOf('#');
		if (i>=0)
		{	result = uri.substring(i+1);
		}
		else
		{	result=null;
		}
		return result;
	}
	
	
	public String getURIWithoutFragment()
	{	String uri = getURI();
		String result;
		int i=uri.lastIndexOf('#');
		if (i>=0)
		{	result = uri.substring(0,i);
		}
		else
		{	result=uri;
		}
		return result;
	}		
	
	public boolean isActiveURI()
	{	return mActive!=null;
	}

	public String getActiveType()
	{	String result = null;
		if (isActiveURI())
		{	result = mActive.getType();
		}
		return result;
	}
	
	public boolean argumentExists(String aName)
	{	boolean result=false;
		if (isActiveURI())
		{	result = mActive.get(aName)!=null;
		}
		return result;
	}
	
	public String getArgument(String aName)
	{	String result=null;
		if (isActiveURI())
		{	String uriString = mActive.get(aName);
			if (uriString!=null)
			{	result = uriString;
			}
		}
		return result;
	}
	
	public Iterator getArguments()
	{	Iterator result = Collections.EMPTY_LIST.iterator();
		if (isActiveURI())
		{	ArrayList list = new ArrayList(8);
			for (Iterator i=mActive.getArgs(); i.hasNext(); )
			{	CompoundURIdentifier.CompoundURIStruct struct = (CompoundURIdentifier.CompoundURIStruct)i.next();
				list.add(struct.getKey());
			}
			result = list.iterator();
		}
		return result;
	}
	
	public IURRepresentation getArgumentValue(String aURI)
	{	return mRequest.getArg(new URIdentifier(aURI));
	}

}