/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: NKFAsyncRequestHandleImpl.java,v $
 * Version:       $Name:  $ $Revision: 1.5 $
 * Last Modified: $Date: 2005/05/26 10:55:40 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf.impl;

import org.ten60.netkernel.layer1.nkf.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.util.*;

import java.lang.reflect.*;

/**
 *
 * @author  tab
 */
public class NKFAsyncRequestHandleImpl implements INKFAsyncRequestHandle, IURRequestor, InvocationHandler
{
	private NKFRequestImpl mRequest;
	private NKFHelperImpl mHelper;
	private IURRepresentation mResult;
	private boolean mException;
	private INKFAsyncRequestListener mListener;
	private IURRepresentation mResponse;
	private boolean mResponseSet;
	
	/** Creates a new instance of NKFSubRequestImpl */
	public NKFAsyncRequestHandleImpl(NKFRequestImpl aRequest, NKFHelperImpl aHelper)
	{	mRequest = aRequest;
		mHelper = aHelper;
	}
	
	public IURRepresentation join() throws NKFException, InterruptedException
	{	return join(0);
	}

	public IURRepresentation join(long aTimeout) throws NKFException, InterruptedException
	{	synchronized(mRequest)
		{	if (mResult==null)
			{	mRequest.wait(aTimeout);
			}
		}
		if (mResult!=null)
		{	if (mException)
			{	NKFException ex=handleException();
				throw ex;
			}
			else
			{	mHelper.declareDependency(mRequest.getKernelRequest().getURI(),mResult);
				return mResult;
			}
		}
		else
		{	return null;
		}
	}
	
	public void setListener(INKFAsyncRequestListener aListener)
	{	boolean issueCallbackNow=false;
		synchronized(mRequest)
		{	mListener=aListener;
			if (mResult!=null)
			{	issueCallbackNow=true;
			}
		}
		if (issueCallbackNow)
		{	issueCallback();
		}
	}
	
	 void setResult(IURRepresentation aResult)
	{	mResult = aResult;
	}
	
	public void receiveAsyncException(URResult aResult)
	{	innerReceive(aResult,true);
	}
	public void receiveAsyncResult(URResult aResult)
	{	innerReceive(aResult,false);
	}
	
	private void innerReceive(URResult aResult, boolean aException)
	{	boolean issueCallbackNow=false;
		synchronized(mRequest)
		{	mResult=aResult.getResource();
			mException=aException;
			mRequest.notify();
			if (mListener!=null)
			{	issueCallbackNow=true;
			}
		}
		issueCallback();
	}
	
	private void issueCallback()
	{	try
		{	if (mListener!=null)
			{	// build proxy around helper to deal with separate response
				Class[] classes=new Class[]{INKFConvenienceHelper.class, INKFBasicHelper.class};
				INKFConvenienceHelper proxy = (INKFConvenienceHelper)Proxy.newProxyInstance(this.getClass().getClassLoader(), classes, this);
				
				if (mException)
				{	NKFException nkfe=handleException();
					mListener.receiveException(nkfe,mRequest,proxy);
				}
				else
				{	mListener.receiveRepresentation(mResult,mRequest,proxy);
				}
				mHelper.handleAsyncResponse(getResponse());
			}
		}
		catch (Exception e)
		{	mHelper.handleAsyncException(e);
		}
	}
	
	/** both errors and exceptions must be passed back to callback so that any
	 * asynchronous "finally" handlers can be executed.
	 */
	private NKFException handleException()
	{	IAspectNetKernelException aspect = (IAspectNetKernelException)mResult.getAspect(IAspectNetKernelException.class);
		NKFException result;
		NetKernelError error = aspect.getError();
		if (error!=null)
		{	result = new NKFException(error.getId(),error.getMessage(),mRequest.getKernelRequest().toString());
			result.addCause(error.getCause());
		}
		else
		{	NetKernelException e = aspect.getException();
			result = new NKFException(e.getId(),e.getMessage(),mRequest.getKernelRequest().toString());
			result.addCause(e.getCause());
		}
		return result;
	}
	
	/** intercept the setResponse methods and capture response local to this request listener
	 **/
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
	{	if (method.getName().equals("setResponse"))
		{	Object arg =args[0];
			if (arg instanceof NKFResponseImpl)
			{	mResponse = ((NKFResponseImpl)arg).getResponse();
			}
			else if (arg instanceof IURRepresentation)
			{	mResponse = (IURRepresentation)arg;
			}
			mResponseSet = true;
			return null;
		}
		else
		{	return method.invoke(mHelper,args);
		}
	}
	
	IURRepresentation getResponse()
	{	if (!mResponseSet)
		{	mResponse = VoidAspect.create();
		}
		mResponseSet=false;
		return mResponse;
	}	
}