/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: NKFAccessorImpl.java,v $
 * Version:       $Name:  $ $Revision: 1.16 $
 * Last Modified: $Date: 2005/05/16 13:34:25 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf.impl;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.scheduler.Scheduler;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.aspect.*;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.representation.SimpleRepresentationImpl;
import org.ten60.netkernel.layer1.meta.AccessorMeta;
import com.ten60.netkernel.urrequest.URRequest;

/**
 * The main base-class for creating accessors using the NetKernel Foundation API
 * @author  tab
 */
public abstract class NKFAccessorImpl extends SimpleRepresentationImpl implements IURAccessor
{
	private URIdentifier mURI;
	ModuleDefinition mModule;
	Container mContainer;
	Scheduler mScheduler;
    
    /** Creates a new instance of NKFAccessorImpl */
    public NKFAccessorImpl(int aCreationCost, boolean aIsThreadSafe, int aRequestTypes)
    {	super(new AccessorMeta(aCreationCost,aIsThreadSafe,aRequestTypes));
    }
	
	protected void declareThreadSafe()
	{	((AccessorMeta)getMeta()).setThreadSafe(true);
	}
	
	public IURAccessorMeta getAccessorMeta()
	{	return (IURAccessorMeta)getMeta();
	}
	
	public void init(URIdentifier aURI, ModuleDefinition aModule, Container aContainer) throws com.ten60.netkernel.util.NetKernelException
	{	mURI = aURI;
		mModule=aModule;
		mContainer=aContainer;
		mScheduler = (Scheduler)mContainer.getComponent(Scheduler.URI);
	}
	
	/** @return our URI
	 */
	public final URIdentifier getURI()
	{	return mURI;
	}
    
	/** subclasses of this accessor cannot issue any asychronous requests */
	public final void receiveAsyncException(URResult aResult) {}
	/** subclasses of this accessor cannot issue any asychronous requests */
	public final void receiveAsyncResult(URResult aResult) {}

	final public void requestAsync(URRequest aRequest)
    {	try
		{	Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
			NKFHelperImpl context = new NKFAccessorHelperImpl(mContainer,mModule,mScheduler,aRequest,this.getClass().getName());
			processRequest(context);
			IURRepresentation rep = context.getResponse();
			if (rep!=null)
			{	URResult result = new URResult(aRequest, rep);
				mScheduler.receiveAsyncResult(result);
			}
		}
		catch (Exception ex)
		{	NetKernelException e = new NetKernelException("Unhandled Exception in Accessor",getClass().getName(), aRequest.toString());
			e.addCause(ex);
			URResult result = new URResult(aRequest, NetKernelExceptionAspect.create(e));
			mScheduler.receiveAsyncException(result);			
		}
    }
	
	/** subclasses should override this method to perform work
	 * @arg context the NKF context object
	 * @throws Throwable if anything goes wrong
	 */
	public abstract void processRequest(INKFConvenienceHelper context) throws Exception;
    
}