/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: WormholeAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2004/09/10 17:20:34 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.accessor;
import org.ten60.netkernel.layer1.util.*;
import org.ten60.netkernel.layer1.representation.MirrorRepresentation;

import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.module.*;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.*;
import java.util.*;

/**
 * WormholeAccessor
 * @author  tab
 */
public class WormholeAccessor extends ActiveAccessorImpl
{
	public static final String ARG_RESOURCE="resource";
	public static final String ARG_MODULE="module";
	public static final String ARG_VERSION="version";
	
	private final Map mRequestMap = Collections.synchronizedMap(new IdentityHashMap());
	/** Creates a new instance of WormholeAccessor */
	public WormholeAccessor()
	{	super(2, true);
	}
	
	public void requestAsync(URRequest aRequest)
	{	try
		{	CompoundURIdentifier uri = new CompoundURIdentifier(aRequest.getURI());
			URIdentifier module=null;
			Version version=null;
			String resourceString=null;
			CompoundURIdentifier resource=null;
			PairList byValueArgs=null;
			PairList byRefArgs=new PairList(2);
			
			for ( Iterator i = uri.getArgs(); i.hasNext(); )
			{	CompoundURIdentifier.CompoundURIStruct argStruct = (CompoundURIdentifier.CompoundURIStruct)i.next();
				String arg = argStruct.getKey();
				if (arg.equals(ARG_MODULE))
				{	module = new URIdentifier(argStruct.getURI());
				}
				else if (arg.equals(ARG_VERSION))
				{	String versionString = argStruct.getURI();
					if (versionString.startsWith("version:"))
					{	versionString = versionString.substring(8);
					}
					version = new Version(versionString);
				}
				else if (arg.equals(ARG_RESOURCE))
				{	resourceString =argStruct.getURI();
					resource = new CompoundURIdentifier(new URIdentifier(resourceString));
				}
				else
				{	URIdentifier argURI = new URIdentifier(argStruct.getURI());
					IURRepresentation rep = aRequest.getArg(argURI);
					if (rep!=null)
					{	if (byValueArgs==null)
						{	byValueArgs = new PairList(2);
						}
						byValueArgs.put(argURI, rep);
						//System.out.println("module byValue "+argStruct.getURI());
					}
					byRefArgs.put(arg,argStruct.getURI());
				}
			}
					
			if (module==null || resource==null)
			{	throw new NetKernelException("required args of module and resource not supplied");
			}
			
			for (int i=0; i<byRefArgs.size(); i++)
			{	resource.addArg((String)byRefArgs.getValue1(i),(String)byRefArgs.getValue2(i));
			}

			ModuleManager mm = (ModuleManager)getContainer().getComponent(ModuleManager.URI);
			ModuleDefinition context = mm.getModule(module, version, version);
			if (context==null)
			{	String message = "The module ["+module.toString()+"] is not found";
				throw new NetKernelException("module not found",message, module.toString());
			}
			if (!context.getExportedURIMatches().matches(resourceString))
			{	String message = "The URI ["+resourceString+"] is not exported from module ["+module.toString()+"]";
				throw new NetKernelException("URI not exported",message,resourceString);
			}

			if (aRequest.getType()==URRequest.RQT_SOURCE)
			{	URRequest request = new URRequest(resource.toURI(),this,aRequest.getSession(),context,URRequest.RQT_SOURCE,null,aRequest,aRequest.getAspectClass());
				request.setCurrentContext(context, null);
				if (byValueArgs!=null)
				{	for (int i=0; i<byValueArgs.size(); i++)
					{	request.addArg((URIdentifier)byValueArgs.getValue1(i),(IURRepresentation)byValueArgs.getValue2(i));
					}
				}
				
				mRequestMap.put(request,aRequest);
				getScheduler().requestAsync(request);
			}
			else
			{	throw new NetKernelException("unsupported request type");
			}
		}
		catch (NetKernelException e)
		{	IURRepresentation resource = NetKernelExceptionAspect.create(e);
			URResult result = new URResult(aRequest, resource);
			getScheduler().receiveAsyncException(result);
		}
	}
	
	public void receiveAsyncResult(URResult aResult)
	{	IURRepresentation resource = aResult.getResource();
		URRequest original = (URRequest)mRequestMap.remove(aResult.getRequest());
		if (resource.hasAspect(original.getAspectClass()))
		{
			resource = MirrorRepresentation.createIntermediate(resource); // stop from being cached
			URResult result = new URResult(original, resource);
			getScheduler().receiveAsyncResult(result);
		}
		else
		{	// we must transrepresent it
			URRequest first = aResult.getRequest();
			URRequest request = new URRequest(first.getURI(),this,original.getSession(),original.getContext(),URRequest.RQT_TRANSREPRESENT,null,null,original.getAspectClass());
			request.addArg(URRequest.URI_SYSTEM, resource);
			mRequestMap.put(request,original);
			getScheduler().requestAsync(request);
		}
	}
	public void receiveAsyncException(URResult aResult)
	{	IURRepresentation resource = aResult.getResource();
		//IAspectNetKernelException exceptionAspect = (IAspectNetKernelException)resource.getAspect(IAspectNetKernelException.class);
		URRequest original = (URRequest)mRequestMap.remove(aResult.getRequest());
		URResult result = new URResult(original, resource);
		getScheduler().receiveAsyncException(result);
	}
	
}