<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	
    <xsl:template match="/">
		<stats>
			<mirror><xsl:value-of select="$param/*"/></mirror>
			<xsl:for-each select="/dependencies/selected/modules/module">
				<xsl:call-template name="update"/>
			</xsl:for-each>
			<xsl:for-each select="/dependencies/available/modules/module">
				<xsl:call-template name="add"/>
			</xsl:for-each>
			<xsl:for-each select="/dependencies/upgrade/modules/module">
				<xsl:call-template name="update"/>
			</xsl:for-each>
		</stats>
    </xsl:template>
	
	<xsl:template name="add">
		<add>
			<uri><xsl:value-of select="uri"/></uri>
			<version><xsl:value-of select="version"/></version>
		</add>
	</xsl:template>

	<xsl:template name="update">
		<update>
			<uri><xsl:value-of select="uri"/></uri>
			<version><xsl:value-of select="version"/></version>
		</update>
	</xsl:template>

</xsl:stylesheet> 
