/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: BackupConfigAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/08/17 16:43:57 $
 *****************************************************************************/
package org.ten60.netkernel.ext_install.installer.rollback;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.util.Utils;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.Version;

import java.net.*;
import java.util.*;
import java.io.*;
import org.w3c.dom.*;
/**
 *	Backup the operand to a unique backup location and return the URI of the backup
 * @author  tab
 */
public class BackupConfigAccessor extends NKFAccessorImpl
{
	private static String backupBase="ffcpl:/org/ten60/netkernel/ext_install/installer/rollback/backup";
	
	public BackupConfigAccessor()
	{	super(0,false,INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	do
		{	String filename=backupBase+Integer.toString((int)(Math.random()*65536))+".xml";
			if (!context.exists(filename))
			{	// store file
				IURAspect configAspect = context.sourceAspect("this:param:operand",IURAspect.class);
				context.sinkAspect(filename, configAspect);
				
				// set response
				INKFResponse response = context.createResponseFrom(new StringAspect("<uri>"+filename+"</uri>"));
				response.setMimeType("text/xml");
				response.setExpired();
				context.setResponse(response);
				break;
			}
		} while(true);
	}
	
}