<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	
    <xsl:template match="/modules">
		<modules>
			<xsl:apply-templates/>
		</modules>
    </xsl:template>
	
	<xsl:template match="module">
		<module>
			<xsl:for-each select="*">
				<xsl:choose>
					<xsl:when test="name()='source'">
						<source><xsl:value-of select="concat($param/*/text(),text())"/></source>
					</xsl:when>
					<xsl:when test="name()='icon'">
						<icon><xsl:value-of select="concat($param/*/text(),text())"/></icon>
					</xsl:when>
					<xsl:when test="name()='info'">
						<info><xsl:value-of select="concat($param/*/text(),text())"/></info>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<editable/>
		</module>
	</xsl:template>

</xsl:stylesheet> 
