/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: ProcessDependenciesAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2004/08/05 10:39:42 $
 *****************************************************************************/
package org.ten60.netkernel.ext_install.installer.add;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.Version;

import java.net.*;
import java.util.*;
import org.w3c.dom.*;
/**
 *	Process dependencies needed on adding new modules
 * @author  tab
 */
public class ProcessDependenciesAccessor extends XAccessor
{
	public ProcessDependenciesAccessor()
	{	declareArgument(XAccessor.OPERAND, true, false); // nvp param with list of modules
		declareArgument(XAccessor.OPERATOR, true, false); // netkernel:module
		declareArgument(XAccessor.PARAMETER, true, false); // modules.xml server list
	}
	
	/**
	static class DependencyStruct
	{	public String mXPath;
		public IXDAReadOnly mDocument;
		public DependencyStruct(IXDAReadOnly aDocument, String aXPath)
		{	mDocument = aDocument;
			mXPath = aXPath;
		}
	}**/
	
	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		IXDAReadOnly selected = aHelper.getOperand().getXDA();
		IXDAReadOnly serverList = aHelper.getParameter().getXDA();
		IXDAReadOnly modules = aHelper.getOperator().getXDA();
		
		// build template result document
		Document d = XMLUtils.newDocument();
		DOMXDA xda = new DOMXDA(d,false);
		xda.appendPath("/", "dependencies", null);
		xda.appendPath("/dependencies", "selected/modules", null);
		xda.appendPath("/dependencies", "available/modules", null);
		xda.appendPath("/dependencies", "upgrade/modules", null);
		xda.appendPath("/dependencies", "unavailable/modules", null);
		xda.appendPath("/dependencies", "fulcrums/modules", null);
		
		boolean anyApplications=false;
		// build selected list
		for (IXDAReadOnlyIterator i = selected.readOnlyIterator("/nvp/module"); i.hasNext(); )
		{	i.next();
			String m = i.getText(".", true);
			int j = m.indexOf('@');
			String uriString = m.substring(0,j);
			String versionString = m.substring(j+1);
			String xpath = "/modules/module[uri='"+uriString+"' and version='"+versionString+"']";
			xda.append(serverList, xpath, "/dependencies/selected/modules");
			xda.delete("/dependencies/selected/modules/module[last()]/editable");
			xpath="/dependencies/selected/modules/module[last() and type='application']";
			if (xda.isTrue(xpath))
			{	anyApplications=true;
			}
		}
		
		// create initial dependency list
		List dependencies = new ArrayList();
		for (IXDAReadOnlyIterator i = xda.readOnlyIterator("/dependencies/selected/modules/module/dependencies/module"); i.hasNext(); )
		{	i.next();
			IXDAReadOnly dependency = i.readOnlyIterator(".");
			dependencies.add(dependency);
		}
		
		
		int iterations = 0;
		while (dependencies.size()>0)
		{	if (iterations++ >10)
			{	throw new NetKernelException("circular dependencies");
			}
			for (Iterator iter = dependencies.iterator(); iter.hasNext(); )
			{	
				IXDAReadOnly i = (IXDAReadOnly)iter.next();
				iter.remove();
				String uriString = i.getText("uri", true);
				
				Version minVersion=null,maxVersion=null;
				try
				{	minVersion = new Version(i.getText("version-min",true));
				} catch (XPathLocationException e) {;}
				try
				{	maxVersion = new Version(i.getText("version-max",true));
				} catch (XPathLocationException e) {;}
				
				// see if we have it installed already
				String xpath = "/modules/module[identity/uri='"+uriString+"']";
				boolean found=false;
				
				boolean wrongVersion =false;
				for (IXDAReadOnlyIterator j = modules.readOnlyIterator(xpath); j.hasNext(); )
				{	j.next();
					Version v = new Version(j.getText("identity/version",true));
					if ( (minVersion==null || minVersion.isLessOrEqualThan(v))
						&&  (maxVersion==null || maxVersion.isGreaterOrEqualThan(v)))
					{	// we have it
						found=true;
						break;
					}
					else
					{	wrongVersion=true;
					}
				}
				
				if (!found)
				{	//see if we have it in our install dependencies already
					String xpath2 = "/dependencies/*/modules/module[uri='"+uriString+"']";
					for (IXDAReadOnlyIterator j = xda.readOnlyIterator(xpath2); j.hasNext(); )
					{	j.next();
						Version v = new Version(j.getText("version",true));
						if ( (minVersion==null || minVersion.isLessOrEqualThan(v))
							&&  (maxVersion==null || maxVersion.isGreaterOrEqualThan(v)))
						{	found=true;
						}
					}
				}
				if (!found)
				{	//see if we have it in our original selection already
					String xpath2 = "/dependencies/selected/modules/module[uri='"+uriString+"']";
					for (IXDAReadOnlyIterator j = xda.readOnlyIterator(xpath2); j.hasNext(); )
					{	j.next();
						Version v = new Version(j.getText("version",true));
						if ( (minVersion==null || minVersion.isLessOrEqualThan(v))
							&&  (maxVersion==null || maxVersion.isGreaterOrEqualThan(v)))
						{	found=true;
						}
					}
				}
				
				boolean dependencyAdded=false;
				if (!found)
				{	// see if we have it on the download server
					String xpath3 = "/modules/module[uri='"+uriString+"']";
					for (IXDAReadOnlyIterator j = serverList.readOnlyIterator(xpath3); j.hasNext(); )
					{	j.next();
						Version v = new Version(j.getText("version",true));
						if ( (minVersion==null || minVersion.isLessOrEqualThan(v))
							&&  (maxVersion==null || maxVersion.isGreaterOrEqualThan(v)))
						{	// we have it- check if can be upgraded or must be added
							if (wrongVersion)
							{	//check what version constraints already exist
								Version upgradeMinVersion = null, upgradeMaxVersion = null;
								for (IXDAReadOnlyIterator k = modules.readOnlyIterator("/modules/module/raw/module/mapping/import[uri='"+uriString+"']"); k.hasNext(); )
								{	k.next();
									try
									{	Version v2 = new Version(k.getText("version-min",true));
										if (upgradeMinVersion==null ||upgradeMinVersion.isGreaterThan(v2))
										{	upgradeMinVersion = v2;
										}
									} catch (XPathLocationException e) {;}
									try
									{	Version v2 = new Version(k.getText("version-max",true));
										if (upgradeMaxVersion==null ||upgradeMaxVersion.isLessThan(v2))
										{	upgradeMaxVersion = v2;
										}
									} catch (XPathLocationException e) {;}
									
								}
								boolean canUpgrade = ( (upgradeMinVersion==null || upgradeMinVersion.isGreaterOrEqualThan(v))
																		&& (upgradeMaxVersion==null || upgradeMaxVersion.isLessOrEqualThan(v)) );
								
								if (canUpgrade)
								{	xda.append(j, ".", "/dependencies/upgrade/modules");
									found=true;
								}
							}
							if (!found)
							{	xda.append(j, ".", "/dependencies/available/modules");
								found=true;
							}
							// now add its dependencies also
							for (IXDAReadOnlyIterator subDependencies = j.readOnlyIterator("dependencies/module"); subDependencies.hasNext(); )
							{	subDependencies.next();
								IXDAReadOnly dependency = subDependencies.readOnlyIterator(".");
								dependencies.add(dependency);
								dependencyAdded=true;
							}
							break;
						}
					}
				}
				
				if (!found)
				{	xda.append(i, ".", "/dependencies/unavailable/modules");
					IXDA cursor = xda.iterator("/dependencies/unavailable/modules/module[last()]");
					cursor.appendPath(".", "name", i.getText("uri",true));
					if (minVersion!=null || maxVersion!=null)
					{	String versionString="version ";
						if (minVersion!=null)
						{	versionString+=">="+minVersion.toString(3);
						}
						versionString+=" ";
						if (maxVersion!=null)
						{	versionString+="<="+maxVersion.toString(3);
						}
						cursor.appendPath(".", "desc", versionString);
					}
				}
				
				if (dependencyAdded) break; // otherwise we'll get concurrent modification in dependencies iterator
			}
		}
		
		// make dependencies uneditable
		xda.delete("/dependencies/upgrade/modules/module/editable");
		xda.delete("/dependencies/available/modules/module/editable");

		
		
		// look for deployed fulcrums for downloaded apps
		if (anyApplications)
		{	for (IXDAReadOnlyIterator j = modules.readOnlyIterator("/modules/module[raw/module/info/type='fulcrum']"); j.hasNext(); )
			{	j.next();
				xda.appendPath("/dependencies/fulcrums/modules","module", null);
				IXDA cursor = xda.iterator("/dependencies/fulcrums/modules/module[last()]");
				cursor.appendPath(".", "uri", j.getText("identity/uri",true));
				cursor.appendPath(".", "version", j.getText("identity/version",true));
				cursor.appendPath(".", "name", j.getText("info/name",true));
				cursor.appendPath(".", "desc", j.getText("info/description",true));
				if (j.isTrue("info/editable='true'"))
				{	cursor.appendPath(".", "editable", "true");
				}
				
			}
		}

		// look at dependencies
		/*
		for (Iterator i = dependencies.iterator(); i.hasNext(); )
		{	String dependencyKey = (String)i.next();
			int j = dependencyKey.indexOf('@');
			String uriString = dependencyKey.substring(0,j);
			String versionString = dependencyKey.substring(j+1);
			
		}
		*/
			
			
		
		
		IURRepresentation result = DOMXDAAspect.create(aHelper.getDependencyMeta("text/xml", 64), xda);
		return result;
	}
}