<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : basicstyle.xsl
    Created on : 31 January 2003, 14:03
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/section/content">
		<text>
			<br/>
		<table cellspacing="10" cellpadding="0">
			<xsl:for-each select="chapter[(position() mod 3)-1 = 0]">
			<tr>
				<xsl:apply-templates select=". | following-sibling::chapter[position() &lt; 3]"/>
			</tr>
			</xsl:for-each>
		</table>
		</text>
    </xsl:template>
	
	<xsl:template match="chapter">
		<td>
		<xsl:attribute name="style">
            <xsl:choose>
                <xsl:when test="@app='kernel'">
                    background-color: #c0c0ff;
                </xsl:when>
                <xsl:when test="starts-with(@app,'ext')">
                    background-color: #e0e0ff;
                </xsl:when>
                <xsl:otherwise>
                    background-color: #f0f0ff;
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
		<xsl:call-template name="cell"/>
		</td>
	</xsl:template>

	<xsl:template name="cell">
		<table cellspacing="0" border="0" cellpadding="0">
		<tr>
		<td style="background-color: #0000aa; padding-bottom: 2px; text-align: center;  color: #FFFFFF">
		<h2 style="margin-top: 0px; margin-bottom: 2px; color: #FFFFFF" ><xsl:value-of select="title"/></h2>
        <p style="font-size: 85%;">supplied from <xsl:value-of select="@app"/></p>
        </td>
		</tr>
		<tr>
		<td style="padding-top: 2px; padding-bottom: 2px; vertical-align: top;" width="185">
			
		<ul>
			<xsl:apply-templates select="item"/>
		</ul>
		</td>
		</tr>
		</table>
	</xsl:template>

	<xsl:template match="item">
		<li><xsl:copy-of select="./*"/></li>
    </xsl:template>
	
</xsl:stylesheet> 
