<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes"/>

<xsl:variable name="hour">3600000</xsl:variable>

<xsl:template match="/mls">
		<table>
			<xsl:apply-templates select="dir"/>
			<xsl:apply-templates select="res"/>
		</table>
</xsl:template>

<xsl:template match="dir">
	<tr>
		<td bgcolor="#A5FF99" align="center">
			<xsl:attribute name="rowspan">
				<xsl:value-of select="count(.//res)+(count(.//dir)*2)+2"/>
			</xsl:attribute>	
			<xsl:value-of select="./text()"/>
		</td>
	</tr>
	<tr>
		<td>
			<xsl:apply-templates select="dir"/>
		</td>
		<xsl:for-each select="parent::dir"><td/></xsl:for-each>
	</tr>
	<xsl:for-each select="res">
		<tr >		
			<xsl:call-template name="res"/>
			<xsl:for-each select="parent::dir"><td/></xsl:for-each>
		</tr>
	</xsl:for-each>
</xsl:template>

<xsl:template match="res">
	<tr>
		<xsl:call-template name="res"/>
	</tr>
</xsl:template>

<xsl:template name="res">
	<td colspan="100">
		<xsl:attribute name="bgcolor">
			<xsl:choose>
				<xsl:when test="age &lt; $hour">
					<xsl:text>#ffccff</xsl:text>
				</xsl:when>
				<xsl:when test="( age &gt; $hour ) and (  age &lt; 2*$hour )">
					<xsl:text>#ffccaa</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>#ffff99</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<font size="-1">
				<xsl:call-template name="trimuri">
					<xsl:with-param name="uri" select="@uri"/>
				</xsl:call-template>
			<xsl:value-of select="./text()"/>
			<!--
			<a>
				<xsl:attribute name="href">/xbin/util/format/prettyxml/formatter.idoc?uri=<xsl:value-of select="@uri"/></xsl:attribute>
			[s]
			</a>
			-->
		</font>
	</td>
</xsl:template>

<xsl:template name="trimuri">
	<xsl:param name="uri"/>
	<xsl:choose>
		<xsl:when test="contains($uri, '/')">
			<xsl:call-template name="trimuri">
				<xsl:with-param name="uri" select="substring-after($uri, '/')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>	
			<xsl:value-of select="$uri"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>
