<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes"/>

<xsl:param name="param"/>
<xsl:variable name="filter" select="$param/nvp/filter"/>
<xsl:variable name="age" select="$param/nvp/age"/>
<xsl:variable name="timeselected" select="substring-before ($param/nvp/time, ',')"/>
<xsl:variable name="modselected" select="substring-before ($param/nvp/mod, ',')"/>

<xsl:template match="modules">
	<div>
	<form method="get" action="app9.idoc">
		Mod <select name="mod">
				<option value="1,*">
					<xsl:if test="$modselected=1">
						<xsl:attribute name="selected">true</xsl:attribute>
					</xsl:if>
				All</option>
				<xsl:for-each select="module">
					<xsl:sort select="identity/uri"/>
					<option>
						<xsl:attribute name="value">
							<xsl:value-of select="position()+1"/>,<xsl:value-of select="identity/uri"/>
						</xsl:attribute>
						<xsl:if test="$modselected=position()+1">
							<xsl:attribute name="selected">true</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="identity/uri"/>
					</option>
				</xsl:for-each>
		</select>
		Max Age <input name="age" type="text" style="width: 30; margin-right: 5;">
			<xsl:attribute name="value">
				<xsl:value-of select="$age"/>
			</xsl:attribute>
			</input>
		<select name="time" style="margin-right: 5;">
			<option value="1,0">
			<xsl:if test="$timeselected=1">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			Off</option>
			<option value="2,60">
			<xsl:if test="$timeselected=2">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			Minutes</option>
			<option value="3,3600">
			<xsl:if test="$timeselected=3">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			Hours</option>
			<option value="4,86400">
			<xsl:if test="$timeselected=4">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			Days</option>
			<option value="5,604800">
			<xsl:if test="$timeselected=5">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			Weeks</option>
			<option value="6,2419200">
			<xsl:if test="$timeselected=6">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			Months</option>
			<option value="7,31557600">
			<xsl:if test="$timeselected=7">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			Years</option>
		</select>
		Regex<input name="filter" type="text" style="width: 100; margin-right: 5;">
			<xsl:attribute name="value"><xsl:value-of select="$filter"/></xsl:attribute>
		</input>
		<input type="submit" value="Submit" name="submit"/>
	</form>
	<p>
	<xsl:if test="$modselected > 1">
		<xsl:call-template name="info"/>
	</xsl:if>
	</p>
	</div>
</xsl:template>

<xsl:template name="info">	
	<xsl:for-each select="/modules/module[identity/uri=substring-after ($param/nvp/mod, ',')]">
			<table>
				<tr>
					<td><b>Name:</b></td>
					<td><xsl:value-of select="info/name"/></td>
				</tr>
				<tr>
					<td><b>Desc:</b></td>
					<td><xsl:value-of select="info/description"/></td>
				</tr>
			</table>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
