<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : appfilter.xsl
    Created on : 06 March 2003, 19:42
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml"/>
	
<xsl:param name="param"/>
<xsl:variable name="module" select="substring-after ( $param/nvp/mod/text(), ',' )"/>

    <xsl:template match="/mls">
		<mls>
			<xsl:apply-templates/>
		</mls>
    </xsl:template>
	
	<xsl:template match="dir">
		<xsl:choose>
			<xsl:when test="$module = '*'">
				<dir>
					<xsl:attribute name="name">
						<xsl:value-of select="./text()"/>
					</xsl:attribute>
					<xsl:apply-templates />
				</dir>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="descendant::res[ module/text()= $module]">
					<dir>
						<xsl:attribute name="name">
							<xsl:value-of select="./text()"/>
						</xsl:attribute>
						<xsl:apply-templates />
					</dir>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>

	<xsl:template match="res">
		<xsl:choose>
			<xsl:when test="$module='*'">
				<xsl:copy-of select="."/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="module/text()=$module">
					<xsl:copy-of select="."/>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
		
    </xsl:template>
		
</xsl:stylesheet> 
