<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml"/>

    <xsl:template match="/section">
		<table width="600">
			<xsl:apply-templates select="content"/>
		</table>
    </xsl:template>
	
	<xsl:template match="content">
		<xsl:apply-templates select="changes"/>
	</xsl:template>
	
	<xsl:template match="changes">
		<xsl:apply-templates select="version"/>
	</xsl:template>
	
	<xsl:template match="version">
		<tr bgcolor="#ccccff">
			<td><b><xsl:value-of select="major"/>.<xsl:value-of select="minor"/>.<xsl:value-of select="minorminor"/></b></td>
			<td><xsl:value-of select="date"/></td>
		</tr>
		<xsl:for-each select="change">
			<xsl:call-template name="change"/>
		</xsl:for-each>
    </xsl:template>
	
	<xsl:template name="change">
		<tr>
			<xsl:if test="position() mod 2 = 0">
			<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
			</xsl:if>
		<td><h4><xsl:value-of select="title"/></h4></td>
		<td><xsl:value-of select="desc"/></td>
		</tr>
	</xsl:template>
	
	<!--
	<xsl:template name="menuitem">
		<li>
			<a>
			<xsl:attribute name="href">#<xsl:value-of select="name"/>
			</xsl:attribute>
			<xsl:value-of select="title"/>
			</a>
		</li>
	</xsl:template>
	-->
	
</xsl:stylesheet> 
