<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_title.xsl
    Created on : 01 February 2003, 09:06
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:template match="/">
		<table width="600">
			<tr><td>
			<xsl:apply-templates select="/section/content"/>
			</td></tr>
		</table>
	</xsl:template>
    <!-- template rule matching source root element -->
	<xsl:template match="/section/content">
		<h2>Definition</h2>
		<h3>Format</h3>
		<p>
			<xsl:copy-of select="format"/>
		</p>
		<h3>Syntax</h3>
		<table width="600" bgcolor="#eeeeff">
			<tr bgcolor="#ddddff">
			<td width="70"><b>Element</b></td><td><b>Rules</b></td><td><b>Description</b></td>
			</tr>
            <xsl:apply-templates select = "syntax/*"/>
		</table>
		<br/>
	</xsl:template>
    
    <xsl:template match="syntax/*">
        <tr>
            <td><i><xsl:value-of select="name()"/></i></td>
            <td width="150">
                <xsl:choose>
                    <xsl:when test="@req or name()='type'">
                        <font style="background-color: red; color: white; padding: 1px; font-family:monospace; font-size:90%;">Mandatory</font><xsl:text> </xsl:text> 
                    </xsl:when>
                    <xsl:otherwise>
                        <font style="background-color: blue; color: white; padding: 1px; font-family:monospace; font-size:90%;">Optional</font><xsl:text> </xsl:text> 
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:if test="@frag or name()='target'">
                    <font style="background-color: green; color: white; padding: 1px;font-family:monospace; font-size:90%;">Fragment OK</font>
                </xsl:if>
            </td>
            <td>
                <xsl:copy-of select="."/>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet> 
