<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<!--<xsl:param name="param"/>-->
	<xsl:param name="uri"/>
	<xsl:variable name="doc" select="substring-after($uri/uri,':')"/>
	
	<xsl:key name="items" match="/menu/item | /menu/menu | /menu/menu//*" use="@index | text()">
	</xsl:key>
	<xsl:key name="eps" match="/menu/entrypoints/entrypoint" use="name">
	</xsl:key>
	
	<xsl:template match="/">
	<div style="border-right: solid silver 1px; margin-right: 5px;">
		<table width="170" cellspacing="0" cellpadding="0">
			<xsl:apply-templates select="menu|item"/>
		</table>
	</div>
	</xsl:template>
	
    <xsl:template match="menu">
		<xsl:variable name="name" select="@index"/>
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test=". = /menu">
						<xsl:apply-templates select="menu|item"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="key('items',$doc)/ancestor-or-self::menu[@index=$name]">
								<div>
									<a>
										<xsl:attribute name="class">
											<xsl:choose>
												<xsl:when test="$name=$doc">mds</xsl:when>
												<xsl:otherwise>mdn</xsl:otherwise>
											</xsl:choose>
										</xsl:attribute>
										<xsl:attribute name="href">
											/docengine/<xsl:value-of select="$name"/>
										</xsl:attribute>
										- <xsl:value-of select="key('eps',$name)/indexable/title"/>	
									</a>
								</div>
								<table class="mtab" cellpadding="0">
									<xsl:apply-templates select="*"/>
								</table>
							</xsl:when>
							<xsl:otherwise>
							  <a>
								<xsl:attribute name="class">
									<xsl:choose>
										<xsl:when test="$name=$doc">mds</xsl:when>
										<xsl:otherwise>mdn</xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>
								<xsl:attribute name="href">
									/docengine/<xsl:value-of select="$name"/>
								</xsl:attribute>
								+ <xsl:value-of select="key('eps',$name)/indexable/title"/>	
							  </a>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
    </xsl:template>
	
	<xsl:template match="item">
		<xsl:variable name="name" select="."/>
		<tr><td><a>
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="$name=$doc">mis</xsl:when>
					<xsl:otherwise>min</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="href">/docengine/<xsl:value-of select="$name"/></xsl:attribute>
			<xsl:value-of select="key('eps',$name)/indexable/title"/>	
		</a></td></tr>
	</xsl:template>

</xsl:stylesheet> 