<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/">
            <div class="content" title="Edit Cache Configuration" icon="/mr+module@urn:org:ten60:netkernel:cache:standard+resource@ffcpl:/org/ten60/netkernel/cache/doc/cacheconfig.png"
				desc="Edit the settings of the default Standard Edition cache ">
				<p>This page allows you to change the settings of the default cache configured in NetKernel Standard Edition, for more
				information on the cache settings see the <a href="/ep+name@doc_user_cache_config">Cache Configuration Guide</a>.
				</p>
				<p>Please be careful changing values! - minimal validation is performed. A restart is
				required for changes to take effect.
				</p>
				<form class="title-table" method="post" action="/ep+name@app_cache_standard_conf_editor">
					<table cellspacing="0" cellpadding="1">

						<tr><td colspan="3" style="font-weight: bold;">Level1 Memory Cache</td></tr>
						
						<xsl:call-template name="field">
							<xsl:with-param name="label">Maximum Items</xsl:with-param>
							<xsl:with-param name="name">cacheSize</xsl:with-param>
							<xsl:with-param name="value" select="/config/cacheSize"/>
							<xsl:with-param name="comment">maximum number of items cache will hold</xsl:with-param>
						</xsl:call-template>
						
						<xsl:call-template name="field">
							<xsl:with-param name="label">Prune Size</xsl:with-param>
							<xsl:with-param name="name">pruneSize</xsl:with-param>
							<xsl:with-param name="value" select="/config/pruneSize"/>
							<xsl:with-param name="comment">number of items pruned from cache (good default is 20% of maximum items)</xsl:with-param>
						</xsl:call-template>

						<xsl:call-template name="field">
							<xsl:with-param name="label">Max Memory Threshold</xsl:with-param>
							<xsl:with-param name="name">memoryThreshold</xsl:with-param>
							<xsl:with-param name="value" select="/config/memoryThreshold"/>
							<xsl:with-param name="comment">maximum percentage of heap to allocate to GC baseline (good default is 66%)
							(objects which cannot be GCed)</xsl:with-param>
						</xsl:call-template>

						<xsl:call-template name="field">
							<xsl:with-param name="label">Prune Breather</xsl:with-param>
							<xsl:with-param name="name">putsThreshold</xsl:with-param>
							<xsl:with-param name="value" select="/config/putsThreshold"/>
							<xsl:with-param name="comment">number of PUTS after a prune cycle before memory testing is resumed (good default is 75% of prune size)</xsl:with-param>
						</xsl:call-template>
						
						<xsl:call-template name="field">
							<xsl:with-param name="label">Value Recompute Period</xsl:with-param>
							<xsl:with-param name="name">valuePeriod</xsl:with-param>
							<xsl:with-param name="value" select="/config/valuePeriod"/>
							<xsl:with-param name="comment">minimum number of milliseconds between recompute of cache items value (good default is 5000 - increase to reduce CPU load of large cache)</xsl:with-param>
						</xsl:call-template>

						<tr><td colspan="3" style="font-weight: bold;"><hr/>Level2 Disk Cache</td></tr>

						<tr class="label">
							<td class="label">Enabled:</td>
							<td align="left"><select name="backingCache" size="1">
								<option value="">
									<xsl:if test="/config/backingCache=''">
										<xsl:attribute name="selected">true</xsl:attribute>
									</xsl:if>
									false
								</option>
								<option value="org.ten60.netkernel.cache.filesystem.FilesystemCache">
									<xsl:if test="/config/backingCache='org.ten60.netkernel.cache.filesystem.FilesystemCache'">
										<xsl:attribute name="selected">true</xsl:attribute>
									</xsl:if>
									true
								</option>
							</select></td>
							<td class="comment"></td>
						</tr>
						
						<xsl:call-template name="field">
							<xsl:with-param name="label">Maximum Items</xsl:with-param>
							<xsl:with-param name="name">cacheSize2</xsl:with-param>
							<xsl:with-param name="value" select="/config/config/cacheSize"/>
							<xsl:with-param name="comment">maximum number of items cache will hold</xsl:with-param>
						</xsl:call-template>
						
						<xsl:call-template name="field">
							<xsl:with-param name="label">Prune Size</xsl:with-param>
							<xsl:with-param name="name">pruneSize2</xsl:with-param>
							<xsl:with-param name="value" select="/config/config/pruneSize"/>
							<xsl:with-param name="comment">number of items pruned from cache</xsl:with-param>
						</xsl:call-template>
						
						<xsl:call-template name="field">
							<xsl:with-param name="label">Work Threshold</xsl:with-param>
							<xsl:with-param name="name">representationWorkThreshold</xsl:with-param>
							<xsl:with-param name="value" select="/config/config/representationWorkThreshold"/>
							<xsl:with-param name="comment">minimum cost of resource to be considered worthy of caching</xsl:with-param>
						</xsl:call-template>
						
						<tr><td colspan="3"><hr/></td></tr>
						
						<tr><td align="right" colspan="3">
							<input type="reset" value="Reset"/><input type="submit" value="Update"/>
						</td></tr>
					</table>
				</form>
				<h2/>
            </div>
    </xsl:template>
	
	<xsl:template name="field">
		<xsl:param name="label"/>
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		<xsl:param name="comment"/>
		<xsl:param name="size">8</xsl:param>
		
		<tr class="label">
			<td class="label"><xsl:value-of select="$label"/>:</td>
			<td align="left">
				<xsl:choose>
				<xsl:when test="$name">
					<input size="{$size}" style="text-align: left" name="{$name}" type="text" value="{$value}"/>
				</xsl:when>
				<xsl:otherwise>
					<input size="{$size}" style="background-color: #C0C0C0" disabled="disabled" value="{$value}"/>
				</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="comment"><xsl:value-of select="$comment"/></td>
		</tr>
		
	</xsl:template>

</xsl:stylesheet> 
