<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : transform_bugs.xsl
    Created on : 11 May 2003, 13:21
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
		
	<xsl:param name="param"/>
	
    <xsl:template match="/*">
		<div>
			<style  type="text/css">
			.table { background:#ddddff; }
			.block { background:#eeeeff; padding:3px; }
			.label { font-weight:bold; }
			.error { font-weight:bold; color:red; }
			</style>
			<h2>Search-a-matic</h2>
			<form action="[[xrl:process_search]]" xrl:resolve="action" method="POST">
			<input type="hidden" name="call" value="search_status"/>
			<table bgcolor="#ddddff">
				<tr>
					<td colspan="4">
					<table>
						<tr>
							<td valign="top">
								<span class="label">product:</span><br/>
								<select class="select" id="product" name="product" size="8" maxlength="30" onchange="javascript:newProduct()"/>
							</td>
							<td name="top">
								<span class="label">version:</span><br/>
								<select class="select" id="version" name="version" size="8" maxlength="30" onchange="javascript:newVersion()"/>
							</td>
							<td valign="top">
								<span class="label">component:</span><br/>
								<select class="select" id="component" name="component" size="8" maxlength="30" onchange="javascript:newComponent()"/>
							</td>
							<td valign="top" colspan="2">
								<table cellspacing="4" border="0">
									<tr><td width="300"><span class="label">Section Summary</span></td></tr>
									<tr><td class="block" id="product-desc"/></tr>
									<tr><td class="block" id="version-desc"/></tr>
									<tr><td class="block" id="component-desc"/></tr>
								</table>
							</td>
						</tr>
					</table>
					</td>
				</tr>
				<tr>
					<td>
						<table>
				  <tr valign="top"><td align="left">
					<label for="bug_status" accesskey="a">
					  <select name="bug_status" id="bug_status"
							   size="7">
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="null"/>
							<xsl:with-param name="options" select="$param/selections/bug_status/option"/>
						</xsl:call-template>
					  </select>
					</label>
				  </td><td align="left">
					<label for="resolution" accesskey="r">
					  <select name="resolution" id="resolution"
							   size="7">
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="resolution"/>
							<xsl:with-param name="options" select="$param/selections/resolution/option"/>
						</xsl:call-template>
					  </select>
					</label>
				  </td>
				  <td align="left">
					<label for="bug_severity" accesskey="e">
					  <select name="bug_severity" id="bug_severity"
							   size="7">
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="bug_severity"/>
							<xsl:with-param name="options" select="$param/selections/bug_severity/option"/>
						</xsl:call-template>
					  </select>
					</label>
				  </td>
				  <td align="left">
					<label for="priority" accesskey="i">
					  <select name="priority" id="priority"
							   size="7">
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="priority"/>
							<xsl:with-param name="options" select="$param/selections/priority/option"/>
						</xsl:call-template>
					  </select>
					</label>
				  </td>
				  <td align="left">
					<label for="op_sys" accesskey="o">
					  <select name="op_sys" id="op_sys"
							   size="7">
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="op_sys"/>
							<xsl:with-param name="options" select="$param/selections/op_sys/option"/>
						</xsl:call-template>
					  </select>
					</label>
				  </td>
				  </tr>
				  </table>
				  </td>
				  </tr>
				  <tr>
				  <td>
				  <table>
				  <tr>
				  <td colspan="4"><span class="label">Show bugs changed in the last</span><input value="" name="days" style="width:30;"/><span class="label">days</span></td>
				  <td>
				  <input type="submit" value="Search" />
				  </td>
				  <td>
				  <input type="reset" value="Reset" />
				  </td>
				  </tr>
				  <tr>
					<td colspan="4">
					<span class="label">Assigned To</span><input name="assigned_to" style="width:50;"/>
					<span class="label">QA Contact</span> <input name="qa_contact" style="width:50;"/>
					<span class="label">Reporter</span> <input name="reporter" style="width:50;"/>
					</td>
				  </tr>
				  <tr>
				  <td colspan="4">
				  <span class="label">Limit results to </span><input name="limit" value="25" style="width:25;"/>
				  </td>
				  </tr>
				  <tr>
				  <td colspan="1">
				  <span class="label">Text Field</span>
					<select name="textfield" >
						<option value="title" selected="true">Title</option>
						<option value="short_desc">Description</option>
						<option value="status_report">Status Report</option>
						<option value="resolution">Resolution</option>
						<option value="target">Target</option>
					</select>
					
				  </td>
				  <td colspan="1">
				  <span class="label">Contains</span><input name="match" value="" style="width:150;"/>
				  </td>
				  <td colspan="2">
				  <span class="label">Full Text</span><input name="fulltext" type="checkbox" value="false"/>
				  <span class="label">Boolean</span><input name="booleansearch" type="checkbox" value="false"/>
				  </td>
				  </tr>
				  </table>
				  </td>
				  </tr>
				</table>
				</form>
		<table>
		</table>
		
		<xrl:include href="xrl:javascript_products"/>
	
		<script LANGUAGE="JavaScript">
		<xsl:comment>
		productIndex=0;
		versionIndex=0;
		componentIndex=0;


		function populateProduct()
		{	var select = document.getElementById( 'product' );
			select.options.length=0;
			for (i = 0; i!=data.length; i++)
			{	var productId = data[i][0];
				var option = new Option(productId);
				select.options[i]=option;
			}
			//select.selectedIndex=productIndex;
			descProduct();
			populateVersion();
		}
		function descProduct()
		{	var p = data[productIndex];
			desc = label("product")+p[0]+br()+label("description")+p[1]+br()+label("URN")+p[2];
			document.getElementById( 'product-desc' ).innerHTML=desc;
		}

		function populateVersion()
		{	var select2 = document.getElementById( 'version' );
			select2.options.length=0;
			var versions = data[productIndex][3];
			for (j = 0; j!=versions.length; j++)
			{	var versionId = versions[j][0];
				var option = new Option(versionId);
				select2.options[j]=option;
			}
			//select2.selectedIndex=versionIndex;
			descVersion();
			populateComponent();
		}
		function descVersion()
		{	var v = data[productIndex][3][versionIndex];
			desc = label("version")+v[0]+br()+label("description")+v[1];
			document.getElementById( 'version-desc' ).innerHTML=desc;
		}

		function populateComponent()
		{	var select3 = document.getElementById( 'component' );
			select3.options.length=0;
			var components = data[productIndex][3][versionIndex][2];
			for (k = 0; k!=components.length; k++)
			{	var componentId = components[k][1];
				var option = new Option(componentId);
				option.value=components[k][0];
				select3.options[k]=option;
			}
			//select3.selectedIndex=componentIndex;
			descComponent();
		}
		function descComponent()
		{	var c = data[productIndex][3][versionIndex][2][componentIndex];
			desc = label("component")+c[1]+br()+label("description")+c[2];
			document.getElementById( 'component-desc' ).innerHTML=desc;
		}

		function label(text)
		{	return "\u003cspan class=\u0027label\u0027\u003e"+text+": \u003c/span\u003e";
		}
		function br()
		{	return "\u003cbr/\u003e";
		}	

		function newProduct()
		{   productIndex = document.getElementById( 'product' ).selectedIndex;
			versionIndex=0;
			componentIndex=0;
			descProduct();
			populateVersion();
		}

		function newVersion()
		{   versionIndex = document.getElementById( 'version' ).selectedIndex;
			componentIndex=0;
			descVersion();
			populateComponent();
		}
		function newComponent()
		{   componentIndex = document.getElementById( 'component' ).selectedIndex;
			descComponent()
		}
		function init()
		{	populateProduct();
		}

		init();
		</xsl:comment>
		</script>
		</div>
		
    </xsl:template>
	
	<xsl:template name="selector">
		<xsl:param name="value"/>
		<xsl:param name="options"/>
			<xsl:for-each select="$options">
				<option>
					<xsl:attribute name="value">
						<xsl:value-of select="./@value"/>
					</xsl:attribute>
					<xsl:if test="./text() = $value">
						<xsl:attribute name="selected">true</xsl:attribute>
					</xsl:if>
					<xsl:value-of select="."/>
				</option>
			</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet> 
