<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : transform_bugs.xsl
    Created on : 11 May 2003, 13:21
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xrl="http://1060.org/xrl">
		
	
	
	<xsl:template match="/">
		<div>
			<xsl:apply-templates select="null"/>
			<xsl:apply-templates select="results"/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
			<div style="font-size: 20px;">No bugs match your search</div>
	</xsl:template>
		
	<xsl:template match="results">
		<h2>Search Results</h2>	
		<table>
			<tr bgcolor="#ccccff">
				<td><b>id</b></td>
				<td><b>date</b></td>
				<td><b>title</b></td>
				<td/>
			</tr>
			<xsl:apply-templates select="row"/>
		</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
			<xsl:if test="position() mod 2">
			<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
			</xsl:if>
		<td>
			<a  xrl:resolve="href">
				<xsl:attribute name="href">[[xrl:edit_bug]]?id=<xsl:value-of select="id"/></xsl:attribute>
				<xsl:value-of select="id"/>
			</a>
			
		</td>
		<td>
			<xsl:value-of select="created"/>
		</td>
		<td>
			<xsl:value-of select="title"/>
		</td>
		<td>
			<a style="font-size: 8px;" xrl:resolve="href">
				<xsl:attribute name="href">[[xrl:edit_bug]]?id=<xsl:value-of select="id"/></xsl:attribute>
				view
			</a>
		</td>
		</tr>
	</xsl:template>
	
</xsl:stylesheet> 
