<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : transform_bugs.xsl
    Created on : 11 May 2003, 13:21
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xrl="http://1060.org/xrl">
		
	
	
	<xsl:template match="/">
		<div>
			<xsl:apply-templates select="bug/activity/null"/>
			<xsl:apply-templates select="bug/activity/results"/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
			<div style="font-size: 20px;">No activity found</div>
	</xsl:template>
		
	<xsl:template match="results">
		<h2>Bug Activity</h2>	
		<table>
			<tr bgcolor="#ccccff">
				<td>
					date
				</td>
				<td>
					user
				</td>
				<td>
					field
				</td>
				<td>
					old
				</td>
				<td>
					new
				</td>
			</tr>
			<xsl:apply-templates select="row"/>
		</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
			<xsl:if test="position() mod 2">
			<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
			</xsl:if>
		<td>
			<xsl:value-of select="changed"/>
		</td>
		<td>
			<xsl:variable name="who" select="who"/>
			<xsl:value-of select="/bug/user/results/row[id=$who]/login"/>
		</td>
		<td>
			<xsl:choose>
				<xsl:when test="fieldid=1">id</xsl:when>
				<xsl:when test="fieldid=2">created</xsl:when>
				<xsl:when test="fieldid=3">reporter</xsl:when>
				<xsl:when test="fieldid=4">assigned to</xsl:when>
				<xsl:when test="fieldid=5">qa contact</xsl:when>
				<xsl:when test="fieldid=6">title</xsl:when>
				<xsl:when test="fieldid=7">short desc</xsl:when>
				<xsl:when test="fieldid=8">buggy file</xsl:when>
				<xsl:when test="fieldid=9">priority</xsl:when>
				<xsl:when test="fieldid=10">severity</xsl:when>
				<xsl:when test="fieldid=11">status</xsl:when>
				<xsl:when test="fieldid=12">status report</xsl:when>
				<xsl:when test="fieldid=13">jvm version</xsl:when>
				<xsl:when test="fieldid=14">resolution</xsl:when>
				<xsl:when test="fieldid=15">target</xsl:when>
				<xsl:when test="fieldid=16">confirmed</xsl:when>
			</xsl:choose>
		</td>
		<td>
			<xsl:value-of select="old_value"/>
		</td>
		<td>
			<xsl:value-of select="new_value"/>
		</td>
		</tr>
	</xsl:template>
	
</xsl:stylesheet> 
