<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_products.xsl
    Created on : 10 March 2004, 16:16
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	<xsl:param name="parent"/>
	
	<xsl:template match="/">
		<div>
			<h2>Update Components</h2>
			<xsl:apply-templates select="products/info"/>
		</div>
	</xsl:template>
		
	<xsl:template match="info">
		<xsl:choose>
			<xsl:when test="null">
				<div style="font-size: 20px;">No Components</div>
			</xsl:when>
			<xsl:otherwise>
				<div>
					<form action="[[xrl:admin_process_add_components]]" xrl:resolve="action" method="POST">
					<input type="hidden" name="parent">
						<xsl:attribute name="value">
							<xsl:value-of select="$parent/nvp/id/text()"/>
						</xsl:attribute>
					</input>
					<table>
						<select name="components" type="select" multiple="true" size="20">	
							<xsl:for-each select="results/row">
								<xsl:variable name="id" select="id"/>
								<xsl:variable name="name" select="name"/>
									<xsl:for-each select="/products/versions/results/row[productid=$id]">
									<option>
										<xsl:if test="$param/results/row[id=$id]">
											<xsl:attribute name="selected">
												true
											</xsl:attribute>
										</xsl:if>
										<xsl:attribute name="value">
											<xsl:value-of select="id"/>
										</xsl:attribute>
										<xsl:value-of select="$name"/>-<xsl:value-of select="version"/>
									</option>
									</xsl:for-each>
							</xsl:for-each>
						</select>
					</table>
					<input type="submit"/>
					</form>
				</div>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>

</xsl:stylesheet>
