<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:template match="/">
		<script id="products" language="JavaScript">
			<xsl:comment>
			var data =
				[	<xsl:for-each select="/results/row[parentid='' and not( childid = preceding::childid)]">
							<xsl:call-template name="row">
								<xsl:with-param name="row" select="."/>
							</xsl:call-template>
					</xsl:for-each>
				]
			</xsl:comment>
		</script>
    </xsl:template>
	
	<xsl:template name="row">
		<xsl:param name="row"/>
		<xsl:if test="position()!=1">,</xsl:if>
		["<xsl:value-of select="$row/name"/>","<xsl:value-of select="$row/description"/>","<xsl:value-of select="$row/urn"/>",[ 
		<xsl:variable name="id" select="$row/id"/>
		<xsl:apply-templates select="/results/row[id=$id]" mode="version"/> ] ]
	</xsl:template>

	<xsl:template match="row" mode="version">
		<xsl:if test="position()!=1">,</xsl:if>
		["<xsl:value-of select="version"/>","<xsl:value-of select="descr"/>",[ 
		<xsl:variable name="parentid" select="versionid"/>
		<xsl:apply-templates select="/results/row[parentid=$parentid]" mode="components"/> ] ]
	</xsl:template>

	<xsl:template match="row" mode="components">
		<xsl:if test="position()!=1">,</xsl:if>
		["<xsl:value-of select="versionid"/>", "<xsl:value-of select="name"/>-<xsl:value-of select="version"/>","<xsl:value-of select="description"/>" ]
	</xsl:template>
</xsl:stylesheet> 
