<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : transform_bugs.xsl
    Created on : 11 May 2003, 13:21
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xrl="http://1060.org/xrl">
		
	
	
	<xsl:template match="/">
		<div>
			<xsl:apply-templates select="null"/>
			<xsl:apply-templates select="results"/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
			<div style="font-size: 20px;">You have no bugs</div>
	</xsl:template>
		
	<xsl:template match="results">
		<h3>Active Bugs</h3>	
		<table>
			<tr bgcolor="#ccccff">
				<td width="30"><b>id</b>
					<div style="float: right;">
					<table cellspacing="0" cellpadding="2">
						<tr>
							<td>
								<a href="?orderby=id&amp;direction=ASC"><img src="[[xrl:img_arrow_up]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
						<tr>
							<td>
								<a href="?orderby=id&amp;direction=DESC"><img src="[[xrl:img_arrow_down]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
					</table>
					</div>
				</td>
				<td><b>date</b>
					<div style="float: right;">
					<table cellspacing="0" cellpadding="2">
						<tr>
							<td>
								<a href="?orderby=created&amp;direction=ASC"><img src="[[xrl:img_arrow_up]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
						<tr>
							<td>
								<a href="?orderby=created&amp;direction=DESC"><img src="[[xrl:img_arrow_down]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
					</table>
					</div>
				</td>
				<td width="200"><b>title</b>
					<div style="float: right;">
					<table cellspacing="0" cellpadding="2">
						<tr>
							<td>
								<a href="?orderby=title&amp;direction=ASC"><img src="[[xrl:img_arrow_up]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
						<tr>
							<td>
								<a href="?orderby=title&amp;direction=DESC"><img src="[[xrl:img_arrow_down]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
					</table>
					</div>
				</td>
				<td width="75"><b>status</b>
					<div style="float: right;">
					<table cellspacing="0" cellpadding="2">
						<tr>
							<td>
								<a href="?orderby=bug_status&amp;direction=ASC"><img src="[[xrl:img_arrow_up]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
						<tr>
							<td>
								<a href="?orderby=bug_status&amp;direction=DESC"><img src="[[xrl:img_arrow_down]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
					</table>
					</div>
				</td>
				<td width="75"><b>priority</b>
					<div style="float: right;">
					<table cellspacing="0" cellpadding="2">
						<tr>
							<td>
								<a href="?orderby=priority&amp;direction=ASC"><img src="[[xrl:img_arrow_up]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
						<tr>
							<td>
								<a href="?orderby=priority&amp;direction=DESC"><img src="[[xrl:img_arrow_down]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
					</table>
					</div>
				</td>
				<td width="75"><b>reporter</b>
					<div style="float: right;">
					<table cellspacing="0" cellpadding="2">
						<tr>
							<td>
								<a href="?orderby=reporter&amp;direction=ASC"><img src="[[xrl:img_arrow_up]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
						<tr>
							<td>
								<a href="?orderby=reporter&amp;direction=DESC"><img src="[[xrl:img_arrow_down]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
					</table>
					</div>
				</td>
				<td width="75">
					<b>assigned</b>
					<div style="float: right;">
					<table cellspacing="0" cellpadding="2">
						<tr>
							<td>
								<a href="?orderby=assigned_to&amp;direction=ASC"><img src="[[xrl:img_arrow_up]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
						<tr>
							<td>
								<a href="?orderby=assigned_to&amp;direction=DESC"><img src="[[xrl:img_arrow_down]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
					</table>
					</div>
				</td>
				<td width="75"><b>qa contact</b>
					<div style="float: right;">
					<table cellspacing="0" cellpadding="2">
						<tr>
							<td>
								<a href="?orderby=qa_contact&amp;direction=ASC"><img src="[[xrl:img_arrow_up]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
						<tr>
							<td>
								<a href="?orderby=qa_contact&amp;direction=DESC"><img src="[[xrl:img_arrow_down]]" border="0" xrl:resolve="src"/></a>
							</td>
						</tr>
					</table>
					</div>
				</td>
				<td/>
			</tr>
			<xsl:apply-templates select="row"/>
		</table>
		<a href="[[xrl:mybugxter]]" xrl:resolve="href">View my current bugs</a><br/>
		<a href="[[xrl:mybugxter]]?old" xrl:resolve="href">View my old bugs</a><br/>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
			<xsl:if test="position() mod 2">
			<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
			</xsl:if>
		<td>
			<a  xrl:resolve="href">
				<xsl:attribute name="href">[[xrl:edit_bug]]?id=<xsl:value-of select="id"/></xsl:attribute>
				<xsl:value-of select="id"/>
			</a>
			
		</td>
		<td>
			<xsl:value-of select="created"/>
		</td>
		<td>
			<xsl:value-of select="title"/>
		</td>
		<td >
			<xsl:value-of select="bug_status"/>
		</td>
		<td align="center">
			<xsl:value-of select="priority"/>
		</td>
		<td align="center">
			<xsl:if test="reporter = userid">
				<b>x</b>
			</xsl:if>
		</td>
		<td align="center">
			<xsl:if test="assigned_to = userid">
				<b>x</b>
			</xsl:if>
		</td>
		<td align="center">
			<xsl:if test="qa_contact = userid">
				<b>x</b>
			</xsl:if>
		</td>
		<td>
			<a style="font-size: 8px;" xrl:resolve="href">
				<xsl:attribute name="href">[[xrl:edit_bug]]?id=<xsl:value-of select="id"/></xsl:attribute>
				view
			</a>
		</td>
		</tr>
	</xsl:template>
	
</xsl:stylesheet> 
