<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : nvp_to_updateComponents_batch.xsl
    Created on : 11 March 2004, 10:55
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/nvp">
		<batch>
			<xsl:choose>
				<xsl:when test="component">
					<sql>
					CREATE TEMPORARY TABLE tmpversions
						SELECT versions.* from versions, packages
						WHERE
							<xsl:if test="component">
								versions.id=<xsl:value-of select="component"/>
							</xsl:if>
						;
					</sql>
				</xsl:when>
				<xsl:when test="version  and  not ( component ) ">
					<sql>
						CREATE TEMPORARY TABLE tmpproduct
							SELECT versions.* from versions, products
								WHERE
									versions.version='<xsl:value-of select="version"/>'
							;
					</sql>
					<sql>
						CREATE TEMPORARY TABLE tmpversions
							SELECT versions.* from versions, packages, tmpproduct
								WHERE tmpproduct.id=packages.parentid
									AND packages.childid=versions.id
						;
					</sql>
					<sql>DROP TABLE tmpproduct;</sql>
				</xsl:when>
				<xsl:when test="product and not  ( version ) and  not ( component ) ">
					<sql>
						CREATE TEMPORARY TABLE tmpproduct
							SELECT versions.* from versions, products
								WHERE
									products.name='<xsl:value-of select="product"/>'
									AND products.id=versions.id
							;
					</sql>
					<sql>
						CREATE TEMPORARY TABLE tmpversions
							SELECT versions.* from versions, packages, tmpproduct
								WHERE tmpproduct.id=packages.parentid
									AND packages.childid=versions.id
						;
					</sql>
					<sql>DROP TABLE tmpproduct;</sql>
				</xsl:when>
				<xsl:when test="not ( product ) and not  ( version ) and  not ( component ) ">
					<sql>
						CREATE TEMPORARY TABLE tmpversions
							SELECT * from versions;
							;
					</sql>
				</xsl:when>
			</xsl:choose>
			<sql>
				CREATE TEMPORARY TABLE search
				SELECT bugs.id, bugs.title, bugs.created FROM bugs, bugged, activity, tmpversions, users
					WHERE
						bugs.id=bugged.bugid
						AND bugged.versionid=tmpversions.id
					<xsl:if test="bug_status">
						AND bugs.bug_status="<xsl:value-of select="bug_status"/>"
					</xsl:if>
					<xsl:if test="priority">
						AND bugs.priority="<xsl:value-of select="priority"/>"
					</xsl:if>
					<xsl:if test="resolution">
						AND bugs.resolution="<xsl:value-of select="resolution"/>"
					</xsl:if>
					<xsl:if test="op_sys">
						AND bugs.op_sys="<xsl:value-of select="op_sys"/>"
					</xsl:if>
					<xsl:if test="bug_severity">
						AND bugs.bug_severity="<xsl:value-of select="bug_severity"/>"
					</xsl:if>
					<xsl:if test="days>0">
						AND 
						(
							(
								( TO_DAYS(NOW()) - TO_DAYS(activity.changed) &lt;= <xsl:value-of select="days"/> )
								AND bugs.id=activity.bugid
							)
							OR
							( TO_DAYS(NOW()) - TO_DAYS(bugs.created) &lt;= <xsl:value-of select="days"/> )
						)

					</xsl:if>
					<xsl:if test="string-length(assigned_to) &gt; 0">
						AND users.login="<xsl:value-of select="assigned_to"/>"
						AND users.id=bugs.assigned_to
					</xsl:if>
					<xsl:if test="string-length(reporter) &gt; 0">
						AND users.login="<xsl:value-of select="reporter"/>"
						AND users.id=bugs.reporter
					</xsl:if>
					<xsl:if test="string-length(qa_contact) &gt; 0">
						AND users.login="<xsl:value-of select="qa_contact"/>"
						AND users.id=bugs.qa_contact
					</xsl:if>
					<xsl:if test="string-length(match) &gt; 0">
						<xsl:choose>
							<xsl:when test="textfield='short_desc' and fulltext">
								AND MATCH ( <xsl:value-of select="textfield"/> ) AGAINST ( '<xsl:value-of select="match"/>' )
								<xsl:if test="booleansearch"> IN BOOLEAN MODE</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								AND bugs.<xsl:value-of select="textfield"/> LIKE  '%<xsl:value-of select="match"/>%'
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
					GROUP BY bugs.id
					ORDER BY bugs.created DESC
					LIMIT <xsl:choose>
						<xsl:when test="limit &lt; 50"><xsl:value-of select="limit"/></xsl:when>
						<xsl:otherwise>50</xsl:otherwise>
						</xsl:choose>
					;
			</sql>
			<sql>
				DROP TABLE tmpversions;
			</sql>
		</batch>
    </xsl:template>

</xsl:stylesheet>