<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
    
    <xsl:template match="/">
        <batch>
			<sql>
				SELECT @qa:=affiliations.userid FROM affiliations, products, versions
					WHERE
						affiliations.productid=products.id AND
						versions.id=<xsl:value-of select="/nvp/component/text()"/> AND
						versions.productid=products.id
						LIMIT 1
					;
			</sql>
			<sql>
				SELECT @reporter:=userid FROM sessions 
					WHERE sessions.token="<xsl:value-of select="$param/token/text()"/>"
				;
					
			</sql>
			<sql>
				INSERT INTO bugs VALUES
				(	null,
					NOW(),
					@reporter,
					null,
					@qa,
					'<xsl:value-of select="/nvp/title/text()"/>',
					'<xsl:value-of select="/nvp/short_desc/text()"/>',
					'<xsl:value-of select="/nvp/buggy_file/text()"/>',
					'P3',
					'<xsl:value-of select="/nvp/bug_severity/text()"/>',
					'NEW',
					null,
					'<xsl:value-of select="/nvp/op_sys/text()"/>',
					'<xsl:value-of select="/nvp/jvm_version/text()"/>',
					null,
					null,
					0
				);
			</sql>
			<sql>
				INSERT INTO bugged VALUES (LAST_INSERT_ID(), <xsl:value-of select="/nvp/component/text()"/>);
			</sql>
			<sql>
				CREATE TEMPORARY TABLE tmp
					SELECT bugid from bugged WHERE bugid=LAST_INSERT_ID();
			</sql>
        </batch>
		
<!--
	id				MEDIUMINT NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
    created			DATETIME,
    reporter	    MEDIUMINT(9),
    assigned_to	    MEDIUMINT(9),
    qa_contact	    MEDIUMINT(9),
    short_desc	    MEDIUMTEXT,
    buggy_file	    TEXT,
    priority	    ENUM("-", "P1", "P2",  "P3", "P4", "P5"),
    bug_severity    ENUM("blocker", "critical", "major", "normal" , "minor", "trivial", "enhancement"),
    bug_status	    ENUM("UNCONFIRMED", "NEW", "ASSIGNED", "REOPENED", "RESOLVED", "VERIFIED", "CLOSED"),
    status_report   MEDIUMTEXT,
    op_sys			ENUM("ALL", "Linux", "Win32", "SOLARIS", "HPUX", "AIX", "Other"),
    jvm_version	    TINYTEXT,
    resolution	    VARCHAR(64),
    target			VARCHAR(64),
    confirmed	    TINYINT(4),
    FULLTEXT	    (short_desc)
);

CREATE TABLE IF NOT EXISTS bugxter3.bugged (
    bugid			MEDIUMINT(9),
	versionid		MEDIUMINT(9)
);
-->
    </xsl:template>

</xsl:stylesheet>
