<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	
    <xsl:template match="/">
        <div>
			<xsl:apply-templates />
		</div>
    </xsl:template>
	
	<xsl:template match="null">
		<div style="visibilty: hidden;"/>
	</xsl:template>
	
	
	<xsl:key name="bloggers" match="row" use="login"/>
	
	<xsl:template match="results">
		
		<h1>Members</h1>
		<form action="updateMembers" method="post">
		<input type="hidden" name="blogid">
			<xsl:attribute name="value"><xsl:value-of select="row[1]/blogid"/></xsl:attribute>
		</input>
		<table cellpadding="0" cellspacing="0" width="100%" class="table1">
				<tr class="table1-header">
					<td><b>Userid</b></td>
					<td><b>Name</b></td>
					<td><b>Email</b></td>
						<td>
							Admin
						</td>
						<td>
							Editor
						</td>
						<td>
							Author
						</td>
						<td>
							Member
						</td>
						<td>
							DELETE
						</td>
					</tr>
					
				<xsl:for-each select="row[count(. | key('bloggers', login)[1]) = 1]">
				<xsl:variable name="set" select="key('bloggers', login)"/>
					<tr>
					<td>
						<xsl:value-of select="login"/>
					</td>
					<td>
						<xsl:value-of select="firstname"/> <xsl:value-of select="lastname"/>
					</td>
					<td>
						<xsl:value-of select="email"/>
					</td>
						<td>
							<input name="item" type="checkbox">
								<xsl:attribute name="value">admin,<xsl:value-of select="userid"/></xsl:attribute>
								<xsl:if test="$set[name='admin']">
									<xsl:attribute name="checked">true</xsl:attribute>
								</xsl:if>
							</input>
						</td>
						<td>
							<input name="item" type="checkbox">
								<xsl:attribute name="value">editor,<xsl:value-of select="userid"/></xsl:attribute>
								<xsl:if test="$set[name='editor']">
									<xsl:attribute name="checked">true</xsl:attribute>
								</xsl:if>
							</input>
						</td>
						<td>
							<input name="item" type="checkbox">
								<xsl:attribute name="value">author,<xsl:value-of select="userid"/></xsl:attribute>
								<xsl:if test="$set[name='author']">
									<xsl:attribute name="checked">true</xsl:attribute>
								</xsl:if>
							</input>
						</td>
						<td>
							<input name="item" type="checkbox">
								<xsl:attribute name="value">member,<xsl:value-of select="userid"/></xsl:attribute>
								<xsl:if test="$set[name='member']">
									<xsl:attribute name="checked">true</xsl:attribute>
								</xsl:if>
							</input>
						</td>
						<td>
							<input name="delete" type="checkbox" style="background-color: red;">
								<xsl:attribute name="value"><xsl:value-of select="userid"/></xsl:attribute>
							</input>
						</td>
					</tr>
				</xsl:for-each>
			</table>
			<input type="submit" style="float: right;" value="Change"/>
			</form>
	</xsl:template>
	
</xsl:stylesheet> 
