<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

    <xsl:template match="/">
        <div>
			<h2>Members Blogs</h2>
			<xsl:apply-templates/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
	<div style="font-size: 100%; font-weight: bold;  text-align: center; vertical-align: middle;">No Public Blogs</div>
	</xsl:template>
	
	<xsl:template match="results">
		<table cellpadding="1" cellspacing="0" width="100%" class="table1">
				<tr class="table1-header">
					<td>
					Name
					</td>
					<td>
					Description
					</td>
					<td>
					User
					</td>
					<td colspan="10"/>
				</tr>
				<xsl:apply-templates select="row[access='public']"/>
				<xsl:apply-templates select="row[access='protected']"/>
				<xsl:apply-templates select="row[access='private']"/>
			</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
		<td>
			<xsl:value-of select="name"/>
		</td>
		<td>
			<xsl:value-of select="descr"/>
		</td>
		<td>
			<xsl:value-of select="userid"/>
		</td>
		<td align="right">
			<xsl:choose>
				<xsl:when test="access='private'">
					<form>
						<xsl:call-template name="requestaccess"/>
					</form>
				</xsl:when>
				<xsl:otherwise>
					<form>
						<xsl:call-template name="read"/>
						<xsl:call-template name="requestaccess"/>
					</form>
				</xsl:otherwise>
				
			</xsl:choose>
		</td>
		</tr>
	</xsl:template>
	
	<xsl:template name="read">
		<input type="button" value="read">
			<xsl:attribute name="onclick">javascript:location.href='publish?blogid=<xsl:value-of select="id"/>&amp;page=1&amp;myblog=1'</xsl:attribute>
		</input>
	</xsl:template>

	<xsl:template name="requestaccess">
		<input type="button" value="request access" xrl:resolve="onclick">
			<xsl:attribute name="onclick">javascript:location.href='[[xrl:myblog_requestAccess]]?blogid=<xsl:value-of select="id"/>'</xsl:attribute>
		</input>
	</xsl:template>
</xsl:stylesheet> 
