<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	
    <xsl:template match="/">
        <div>
			<xsl:apply-templates />
		</div>
    </xsl:template>
	
	<xsl:template match="null">
		<div style="visibilty: hidden;"/>
	</xsl:template>
	
	<xsl:template match="myblogs">
		<xsl:apply-templates select="blogs"/>
	</xsl:template>
	
	<xsl:template match="blogs">
		<xsl:apply-templates select="results"/>
	</xsl:template>
	
	<xsl:key name="blogs" match="row" use="id"/>
	
	
	<xsl:template match="results">
		<h2>My Blogs</h2>
		<table cellpadding="1" cellspacing="0" width="100%" class="table1">
				<tr class="table1-header">
					<td width="20%">
					</td>
					<td width="30%">
					</td>
					<td>
					</td>
					<td colspan="2">
						Comments
					</td>
					<td colspan="2">
						Trackbacks
					</td>
					<td colspan="10" width="25%"/>
				</tr>
				<tr class="table1-header">
					<td width="150">
						Name
					</td>
					<td width="300">
						Description
					</td>
					<td>
						Entries
					</td>
					<td align="center">
						<span class="tiny">Appr</span>
					</td>
					<td align="center">
						<span class="tiny">Pend</span>
					</td>
					<td align="center">
						<span class="tiny">Appr</span>
					</td>
					<td align="center">
						<span class="tiny">Pend</span>
					</td>
					<td colspan="10"/>
				</tr>
				<xsl:for-each select="row[count(. | key('blogs', id)[1]) = 1]">
					<xsl:variable name="blogid" select="id"/>
					<tr>
					<td>
						<xsl:value-of select="name"/>
					</td>
					<td>
						<xsl:value-of select="descr"/>
					</td>
					<td align="center">
						<xsl:value-of select="total_entries"/>
					</td>
					<td align="center">
						<xsl:value-of select="/myblogs/stats-comment/results/row[id=$blogid]/total_comments_approved"/>
					</td>
					<td align="center">
						<xsl:value-of select="/myblogs/stats-comment/results/row[id=$blogid]/total_comments_pending"/>
					</td>
					<td align="center">
						<xsl:value-of select="/myblogs/stats-trackback/results/row[id=$blogid]/total_trackbacks_approved"/>
					</td>
					<td align="center">
						<xsl:value-of select="/myblogs/stats-trackback/results/row[id=$blogid]/total_trackbacks_pending"/>
					</td>
					<td>
						
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="key('blogs',id)/grpname='author'">
								<span style="float: left;">
									<form action="startedit" method="post">
										<input type="submit" value="edit"/>
										<input type="hidden" name="blogid">
											<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
										</input>
									</form>
								</span>
								<span style="float: left;">
									<form action="preparestats" method="post">
										<input type="submit" value="statistics"/>
										<input type="hidden" name="blogid">
											<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
										</input>
									</form>
								</span>
							</xsl:when>
							<xsl:otherwise>
								<span style="float: left;">
									<input type="submit" value="edit" disabled="true"/>
								</span>
								<span style="float: left;">
									<input type="submit" value="statistics" disabled="true"/>
								</span>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="key('blogs',id)/grpname='admin'">
								<span style="float: left;">
									<form action="xrl:myblog_startmanage" xrl:resolve="action" method="post">
										<input type="submit" value="manage"/>
										<input type="hidden" name="blogid">
											<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
										</input>
									</form>
								</span>
							</xsl:when>
							<xsl:otherwise>
								<span style="float: left;">
									<input type="submit" value="manage" disabled="true"/>
								</span>
							</xsl:otherwise>
						</xsl:choose>
						
						<xsl:choose>
							<xsl:when test="key('blogs',id)/grpname='member'">
								<span style="float: left;">
									<form action="xrl:myblog_publish" xrl:resolve="action" method="post">
										<input type="submit" value="read"/>
										<input type="hidden" name="blogid">
											<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>

										</input>
										<input type="hidden" value="1" name="page"/>
										<input type="hidden" value="1" name="myblog"/>
									</form>
								</span>
							</xsl:when>
							<xsl:otherwise>
								<span style="float: left;">
									<input type="submit" value="read" disabled="true"/>
								</span>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					</tr>
				</xsl:for-each>
			</table>
	</xsl:template>
	
</xsl:stylesheet> 
