<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:template match="/">
		<xsl:variable name="r" select="12"/>
		<xsl:variable name="w" select="128"/>
		<xsl:variable name="h" select="40"/>
		<xsl:variable name="o" select="7"/>

		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  width="{$w + $o}" height="{$h + $o}"  xml:space="preserve" >
		   <style type="text/css">
			.inner	{font-size:12;fill:#404040;fill-rule:evenodd; stroke: black; stroke-width: 3px; }
			.inner2	{font-size:12;fill:#807bff;fill-rule:evenodd; stroke: black; stroke-width: 3px; }
			.text   {fill:#FFFFFF;stroke:none;font-family:Verdana,Arial,Sans-serif;font-style:normal;font-weight:bold;font-size:22;fill-opacity:1;stroke-opacity:1;stroke-width:1pt;stroke-linejoin:miter;stroke-linecap:butt;text-anchor:middle;writing-mode:lr;}
			</style>

			<filter id="MyFilter" filterUnits="userSpaceOnUse" x="{-$o}" y="-{$o}" width="{$w + 2*$o}" height="{$h + 2*$o}">
				  <desc>Produces a 3D lighting effect.</desc>
				  <feGaussianBlur in="SourceAlpha" stdDeviation="4" result="blur"/>
				  <feOffset in="blur" dx="4" dy="4" result="offsetBlur"/>
				  <feSpecularLighting in="blur" surfaceScale="5" specularConstant=".75" 
									  specularExponent="20" lighting-color="#bbbbbb" 
									  result="specOut">
					<fePointLight x="-5000" y="-10000" z="20000"/>
				  </feSpecularLighting>
				  <feComposite in="specOut" in2="SourceAlpha" operator="in" result="specOut"/>
				  <feComposite in="SourceGraphic" in2="specOut" operator="arithmetic" 
							   k1="0" k2="1" k3="1" k4="0" result="litPaint"/>
							   
				  <feMerge>
					<feMergeNode in="offsetBlur"/>
					<feMergeNode in="litPaint"/>
				  </feMerge>
			</filter>
			<filter id="TextGlow" filterUnits="userSpaceOnUse" x="0" y="0" width="{$w}" height="{$h}">
				  <desc>Produces a 3D lighting effect.</desc>
				  <feGaussianBlur in="SourceAlpha" stdDeviation="1" result="outline"/>
				  <feGaussianBlur in="SourceGraphic" stdDeviation="5" result="blur"/>
				  <feMerge>
					<feMergeNode in="blur"/>
					<feMergeNode in="outline"/>
					<feMergeNode in="SourceGraphic"/>
				  </feMerge>
			</filter>
			<filter id="TextDull" filterUnits="userSpaceOnUse" x="0" y="0" width="{$w}" height="{$h}">
				  <desc>Produces a 3D lighting effect.</desc>
				  <feGaussianBlur in="SourceAlpha" stdDeviation="1" result="outline"/>
				  <feMerge>
					<feMergeNode in="outline"/>
					<feMergeNode in="SourceGraphic"/>
				  </feMerge>
			</filter>
			<xsl:variable name="class"><xsl:choose><xsl:when test="/nvp/highlight" >inner2</xsl:when><xsl:otherwise>inner</xsl:otherwise></xsl:choose></xsl:variable>
			<g > <!--transform="translate(-{$o div 2 },-{$o div 2})"-->
				<xsl:if test="/nvp/background">
					<rect x="0" y="0" width="{$w + $o}" height="{$h + $o}" style="fill: {/nvp/background}"/>
				</xsl:if>
				<g filter="url(#MyFilter)" > <!-- -->
					<!--<path class="inner" d="M60,80 C30,80 30,40 60,40 L140,40 C170,40 170,80 140,80 z" />-->
					<path class="{$class}" d="M{$w - $o - $r},{$o} C{$w},{$o},{$w},{$h - $o},{$w - $o - $r},{$h -$o} L{$r + $o},{$h - $o} C0,{$h - $o},0,{$o},{$r + $o},{$o} z" />
				</g>
				<!--<xsl:variable name="c"><xsl:choose><xsl:when test="/nvp/highlight">text2</xsl:when><xsl:otherwise>text</xsl:otherwise></xsl:choose></xsl:variable>-->
				<g ><xsl:attribute name="filter">url(#TextDull)</xsl:attribute> <!--<xsl:choose><xsl:when test="/nvp/highlight" >url(#TextGlow)</xsl:when><xsl:otherwise>url(#TextDull)</xsl:otherwise></xsl:choose></xsl:attribute>-->
					<text class="text" x="{$w div 2}" y="{$h div 2 + 6 }"><xsl:value-of select="/nvp/value"/></text>
				</g>
			</g>
		</svg>
			
    </xsl:template>
	
	

</xsl:stylesheet> 
