<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_public_search.xsl
    Created on : 25 November 2003, 09:37
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/">
        <div>
			<form action="search" method="post">
				<input type="text" name="search">
					<xsl:attribute name="value"><xsl:value-of select="$param/nvp/search"/></xsl:attribute>
				</input>
				<input type="submit" value="search"/>
			</form>
			<xsl:apply-templates/>
		</div>
    </xsl:template>

	<xsl:template match="null">
	<div>No matches</div>
	</xsl:template>
	
	<xsl:template match="results">
		<table>
			<xsl:apply-templates/>
		</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
			<td>
			<table>
				<tr>
					<td><h3><xsl:value-of select="blogname"/></h3></td>
				</tr>
				<tr>
					<td>
					<h4>
						<a>
							<xsl:attribute name="href">entry?publicid=<xsl:value-of select="publicid"/></xsl:attribute>
							<xsl:value-of select="title"/>
						</a>
					</h4>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:value-of select="summary"/>
					</td>
				</tr>
				<tr>
				<td>
					<table>
					<tr>
					<td>Posted by: <xsl:value-of select="userid"/> on </td><td><xsl:value-of select="dateDayOfMonth"/></td><td><xsl:value-of select="dateMonthName"/></td><td><xsl:value-of select="dateYear"/></td><td> Score: <xsl:value-of select="substring(score, 1, 4)"/></td></tr></table></td>
				</tr>
				</table>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet> 
