<?xml version="1.0" encoding="UTF-8" ?>
<!--
////////////////////////////////////////////////
//Blogxter Default StyleSheet
//
//Formats both full blog and individual entries.
//Formats comments and trackbacks.
//
//Only do layout here. Use CSS for colour, Font etc.
//
//(C) 2003, 1060 Research Ltd
///////////////////////////////////////////////
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	<!--IMPORTANT: Must include the library templates-->
	<xsl:include href="/www/view/lnf/xsl/lib.xsl"/>
	
	<xsl:param name="param"/>
	
    <xsl:template match="/blog">
		<div xmlns:xrl="http://1060.org/xrl" class="blog-master-frame">
			<!--
			/////////////////////////
			//1. The Preliminaries
			/////////////////////////
			-->
			<!--Title-->
			<div id="title" style="display:none;"><xsl:value-of select="meta/results/row/name"/></div>
			<!--
			///////////////////////
			//User CSS substitution
			///////////////////////
			-->
			<div id="replacebystyle"/>  <!--IMPORTANT: This must be included so that it can be replaced by a user CSS style-->
			
			<!--
			//////////////
			//PopUp Script
			//////////////
			-->
			<xsl:call-template name="popupScript"/>  <!--This is required for the popup comment window-->

			<!--A variable to hold the total number of entries -->
			<xsl:variable name="countmain" select="meta/results/row/count"/>
			
			<!--
			/////////////////////
			//2. The main layout
			/////////////////////
			-->
			<table width="100%" class="blog-master-frame" cellspacing="0" cellpadding="0">
				<tr>
					<td width="5%" class="blog-gutter-left">
						<!--
						<xrl:include href="xrl:service_RSSAggregator">
							<nvp>
								<uri>http://www.infoworld.com/rss/news.xml</uri>
							</nvp>
						</xrl:include>
						
						-->
					</td>
					<td>
						<!--
						/////////////////////
						//Site Navigation Tab
						/////////////////////
						-->
						<table cellpardding="0" cellspacing="0" width="100%"> 
							<tr>
								<td width="20%">
									<span style="margin-right: 5px;"><a href="/blogxter/">Home</a></span>
									<span><a href="/blogxter/myblog/">MyBlogxter</a></span>
								</td>
								<td width="80%" class="blog-gutter-right">
								</td>
							</tr>
						</table>
				
						<!--
						///////////////////
						//BLOG TITLE BAR
						///////////////////
						-->
						<table width="100%">
							<tr>
								<td>
									<!--The main title-->
									<div class="blog-title">
										<xsl:value-of select="meta/results/row/name"/>
									</div>
									<div class="blog-sub-title">
										<xsl:value-of select="meta/results/row/descr"/>
									</div>
									<!--
									//////////////////
									//Page Information
									//////////////////
									-->
									<xsl:if test="$param/nvp/full">
										<div style="font-size: 10px;">
											<xsl:variable name="page_low" select="($param/nvp/page - 1) * $countmain +1"/>
											<xsl:variable name="page_high" select="($countmain) * ($param/nvp/page)"/>
											<xsl:variable name="page_max" select="stats-blog/results/row/total_entries"/>
											Entry <xsl:value-of select="$page_low"/>
											<xsl:choose>
												<xsl:when test="$page_low &gt;= $page_high or $page_low=$page_max"/>
												<xsl:when test="$page_high &lt; $page_max">
													- <xsl:value-of select="$page_high"/>
												</xsl:when>
												<xsl:otherwise>
													- <xsl:value-of select="$page_max"/>
												</xsl:otherwise>
											</xsl:choose>
											of <xsl:value-of select="$page_max"/>
											</div>
									</xsl:if>
								</td>
								<td>
									<a href="http://www.1060research.com"><img src="xrl:img_banner_ad" xrl:resolve="src" style="float:right; margin: 25px; border: 0px;"/></a>
								</td>
							</tr>
							<tr>
								<xsl:if test="$param/nvp/full">
									<!--
									////////////////
									//Page Indicator
									////////////////
									-->
									<td>	
										<xsl:variable name="totalpages" select="stats-blog/results/row/total_entries div $countmain"/>
										<table cellpadding="0" cellspacing="0">
											<xsl:call-template name="pages">
											<xsl:with-param name="count" select="1"/>
											<xsl:with-param name="count2" select="1"/>
											<xsl:with-param name="totalpages" select="$totalpages"/>
											<xsl:with-param name="countmain" select="$countmain"/>
											</xsl:call-template>
										</table>
									</td>
								</xsl:if>
							<!--
							////////
							//Search
							////////
							-->
							<td colspan="2">
								<form style="float: right;" action="xrl:blog_search" xrl:resolve="action">
									<input type="hidden" name="blogid">
										<xsl:attribute name="value"><xsl:value-of select="meta/results/row/id"/></xsl:attribute>
									</input>
									<input type="hidden" name="name">
										<xsl:attribute name="value"><xsl:value-of select="meta/results/row/name"/></xsl:attribute>
									</input>
									<label style="font-size: 9px;">
										search	<input style="font-size: 9px; width: 75px;" name="search"/>
									</label>
								</form>
							</td>
							</tr>
						</table>

						<!--
						/////////////////////
						//3. The Entries
						/////////////////////
						-->
						<table cellpadding="0" cellspacing="0" width="100%">
							<xsl:apply-templates select="entries/results/row"/>
						</table>
						<!--
						//////////////////
						//4. The comments
						//////////////////
						-->
						<xsl:if test="$param/nvp/entry and /blog/settings/results/row[setting='COMMENTS']/value > 0">
							<!--
							////////////////
							//Comments Title
							////////////////
							-->
							<table>
								<tr>
									<td>
										<h2>Comments</h2>
										<div class="blog-comment-link">
											<a xrl:resolve="href">	
												<xsl:attribute name="href">javascript:popUp('[[xrl:blog_start_comment]]?publicid=<xsl:value-of select="/blog/entries/results/row/publicid"/>')</xsl:attribute>
												new comment thread
											</a>
										</div>
									</td>
								</tr>
							</table>
							<!--
							//////////////////////
							//Process the comments
							//////////////////////
							-->
							<table cellpadding="0" cellspacing="0" width="100%">
								<tr><td></td></tr>
								<xsl:apply-templates select="comments/results" mode="comment"/>
							</table>
						</xsl:if>
						<!--
						////////////////////
						//5. The trackbacks
						////////////////////
						-->
						<xsl:if test="$param/nvp/entry and /blog/settings/results/row[setting='TRACKBACKS']/value > 0">
							<!--
							//////////////////
							//Trackbacks Title
							//////////////////
							-->
							<table>
								<tr>
									<td>
										<h2>Trackbacks</h2>
										<div style="font-size: 8px;">Trackback this page or Ping: <xsl:value-of select="/blog/meta/results/row/hostname"/>blogxter/trackback/<xsl:value-of select="/blog/entries/results/row/publicid"/></div>
									</td>
								</tr>
							</table>
							<!--
							//////////////////////
							//Process the comments
							//////////////////////
							-->
							<table cellpadding="0" cellspacing="0" width="100%">
								<tr><td></td></tr>
								<xsl:apply-templates select="trackbacks/results" mode="trackback"/>
							</table>
						</xsl:if>
						<!--
						//////////////////////
						//6. Trackback Metadata - must include this for trackback clients to discover trackback interface
						//////////////////////
						-->
						<xsl:call-template name="trackback"/>
						
						<!--
						///////////////////////
						//7. Navigation and RSS
						///////////////////////
						-->
						<xsl:if test="$param/nvp/entry">
							<form>
								<input type="button" value="Back" onclick="history.back()"/>
							</form>
						</xsl:if>
						<!--RSS Link-->
						<div style="margin: 10px; float: right;">
							<a xrl:resolve="href">
								<xsl:attribute name="href">[[xrl:rss]]?blogid=<xsl:value-of select="meta/results/row/id"/></xsl:attribute>
								<img src="xrl:img_RSS_icon" xrl:resolve="src" border="0"/>
							</a>
						</div>
					</td>
					<td width="5%" class="blog-gutter-right"/>
				</tr>
			</table>
		</div>
    </xsl:template>
	
	<!--
	///////////////////////
	//Process Each Entry
	///////////////////////
	-->
	<xsl:template match="row">
		<!--
		/////////////////////
		//The Entry Title Bar
		/////////////////////
		-->
		<tr>
			<td width="100%">
				<table width="100%" class="blog-entry-title-bar">
					<tr>
						<td width="33%">
							<div class="blog-date-group">
									<span class="blog-date-item"><xsl:value-of select="dateDayName"/></span>
									<span class="blog-date-item"><xsl:value-of select="dateDayOfMonth"/></span>
									<span class="blog-date-item"><xsl:value-of select="dateMonthName"/></span>
									<span class="blog-date-item"><xsl:value-of select="dateYear"/></span>
							</div>
						</td>
						<td width="67%">
							<div class="blog-entry-title"><xsl:value-of select="title"/></div>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<!--
		////////////
		//The Entry
		////////////
		-->
		<tr>
			<td>
				<table width="100%">
					<tr>
						<td width="100%">
							<!--
							///////////////////
							//The actual entry!
							///////////////////
							-->
							<xsl:copy-of select="entry"/>
						</td>
							<!--
							/////////////////////////////////////////
							//Polls - pulled in from the poll service
							/////////////////////////////////////////
							-->
							<xrl:include href="xrl:blog_poll_publish">
								<nvp>
									<publicid><xsl:value-of select="publicid"/></publicid>
								</nvp>
							</xrl:include>
					</tr>
				</table>
			</td>
		</tr>
		<!--
		////////////////////////
		//The stats and metadata
		////////////////////////
		-->
		<tr>
			<td>
				<!--
				///////////////////
				//The posted by bar
				///////////////////
				-->
				<span class="blog-posted-bar">
				Posted by <xsl:value-of select="userid"/> at
					<xsl:call-template name="addzero">
						<xsl:with-param name="n" select="timeHour"/>
					</xsl:call-template>:<xsl:call-template name="addzero">
						<xsl:with-param name="n" select="timeMinute"/>
					</xsl:call-template>
				</span>
				
				<!--
				////////////////////////////////////
				//The comment/trackback notification
				////////////////////////////////////
				-->
				<xsl:if test="$param/nvp/full">
					<xsl:variable name="id" select="id"/>
					<span class="blog-comment-bar">
						<a xrl:resolve="href">
							<xsl:attribute name="href">[[xrl:publish_entry]]?publicid=<xsl:value-of select="publicid"/>&amp;token=<xsl:value-of select="$param/nvp/token"/></xsl:attribute>
							comments
						</a> [
						<xsl:variable name="count" select="/blog/stats-comment/results/row[id=$id]/tc"/>
						<xsl:choose>
							<xsl:when test="$count">
								<xsl:value-of select="$count"/>
							</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
						]
						<a xrl:resolve="href">
							<xsl:attribute name="href">[[xrl:publish_entry]]?publicid=<xsl:value-of select="publicid"/>&amp;token=<xsl:value-of select="$param/nvp/token"/></xsl:attribute>
							trackbacks
						</a> [
						<xsl:variable name="count" select="/blog/stats-trackback/results/row[id=$id]/tt"/>
						<xsl:choose>
							<xsl:when test="$count">
								<xsl:value-of select="$count"/>
							</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
						] 
					</span>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>
	
	
	
	<!--
	/////////////////////////////////
	//Process comments with threading
	/////////////////////////////////
	-->
		<!--
		//////////////////////////////////////////////
		//Manchian Grouping Key for threading comments
		//////////////////////////////////////////////
		-->
		<xsl:key name="threaded-comments" match="row" use="title"/>
	<xsl:template match="results" mode="comment">
		<xsl:for-each select="row[count(. | key('threaded-comments', title)[1]) = 1]">
			<tr>
				<td>
					<div class="blog-comment-title">
						<xsl:value-of select="title"/>
					</div>	
					<xsl:for-each select="key('threaded-comments', title)">
						<div>
							<div class="blog-comment-header">
						On		<span class="blog-date-item"><xsl:value-of select="dateDayName"/></span>
								<span class="blog-date-item"><xsl:value-of select="dateDayOfMonth"/></span>
								<span class="blog-date-item"><xsl:value-of select="dateMonthName"/></span>
								<span class="blog-date-item"><xsl:value-of select="dateYear"/></span>
						at		<xsl:call-template name="addzero">
								<xsl:with-param name="n" select="timeHour"/>
								</xsl:call-template>:<span class="blog-date-item">
								<xsl:call-template name="addzero">
									<xsl:with-param name="n" select="timeMinute"/>
								</xsl:call-template>
								</span>

								<span class="blog-comment-author"><xsl:value-of select="author"/></span> commented 
							</div>
							<div class="blog-comment-comment">
								<xsl:copy-of select="comment"/>
							</div>
						</div>
					</xsl:for-each>
					<div class="blog-comment-link">
						<a  xrl:resolve="href">
							<xsl:attribute name="href">javascript:popUp('[[xrl:blog_start_thread_comment]]?title=<xsl:value-of select="title"/>&amp;publicid=<xsl:value-of select="/blog/entries/results/row/publicid"/>')</xsl:attribute>
							reply
						</a>
					</div>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>

	<!--
	/////////////////////////////////
	//Process Trackbacks
	/////////////////////////////////
	-->
	<xsl:template match="results" mode="trackback">
		<xsl:for-each select="row">
			<tr>
				<td>
					<div class="blog-comment-title">
						<xsl:value-of select="title"/>
					</div>	
					<div>
						<div class="blog-comment-header">
					On		<span class="blog-date-item"><xsl:value-of select="dateDayName"/></span>
							<span class="blog-date-item"><xsl:value-of select="dateDayOfMonth"/></span>
							<span class="blog-date-item"><xsl:value-of select="dateMonthName"/></span>
							<span class="blog-date-item"><xsl:value-of select="dateYear"/></span>
					at		<xsl:call-template name="addzero">
							<xsl:with-param name="n" select="timeHour"/>
							</xsl:call-template>:<span class="blog-date-item">
							<xsl:call-template name="addzero">
								<xsl:with-param name="n" select="timeMinute"/>
							</xsl:call-template>
							</span>
							
							<span class="blog-comment-author">
								<a>
								<xsl:attribute name="href"><xsl:value-of select="URL"/></xsl:attribute>
									<xsl:value-of select="blogname"/>
								</a>
							</span> 
							posted
						</div>
						<div class="blog-comment-comment">
							<xsl:copy-of select="excerpt"/>
						</div>
					</div>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	
	
</xsl:stylesheet> 
