<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Public License v1.0 - You may modifiy and
		use this software in any manner provided that any derivative work
		is licensed in compliance with the terms of the 1060 Public License.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/">
        <div class="service-list-main">
			<xsl:apply-templates />
		</div>
    </xsl:template>
	
	
	<xsl:template match="list">
		<xsl:apply-templates select="channel"/>
	</xsl:template>
	
	<xsl:template match="list">
		<div class="service-list-title">
				<xsl:value-of select="title"/>
		</div>
		<xsl:apply-templates select="item"/>
	</xsl:template>
	
	<xsl:template match="item">
		<div class="service-list-item-title">
			<a>
				<xsl:attribute name="href">
					<xsl:choose>
						<xsl:when test="guid">
							<xsl:value-of select="guid"/>	
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="link"/>	
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:value-of select="title"/>
			</a>
		</div>
		<div class="service-list-item-description">
			<xsl:value-of select="description"/>
		</div>
	</xsl:template>
	

</xsl:stylesheet> 
