<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_stats_to_popularity_table.xsl
    Created on : 05 December 2003, 16:26
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	
    <xsl:template match="/stats">
		<table>
			<tr>
			<td valign="top">
				<xsl:if test="topentries/results/row">
					<h2>Most Popular Entries</h2>
					<table width="100%" cellspacing="0" cellpadding="2" class="table2">
						<tr class="table2-header">
							<td/>
							<td width="300">
								Title
							</td>
						</tr>
						<xsl:for-each select="topentries/results/row">
							<tr>
								<td><xsl:value-of select="position()"/></td>
								<td>
									<a>
										<xsl:attribute name="href">entry?publicid=<xsl:value-of select="publicid"/>&amp;token=<xsl:value-of select="$param/nvp/token"/></xsl:attribute>
										<xsl:value-of select="title"/>
									</a>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
			</td>
			</tr>
			<tr>
			<td valign="top">
				<xsl:if test="topblogs/results/row">
					<h2>Top Ten Blogs</h2>
					<table width="100%" cellspacing="0" cellpadding="2" class="table2">
						<tr class="table2-header">
							<td/>
							<td width="300">
								Name
							</td>
						</tr>
						<xsl:for-each select="topblogs/results/row">
							<tr>
								<td><xsl:value-of select="position()"/></td>
								<td>
									<a>
										<xsl:attribute name="href">publish?blogid=<xsl:value-of select="id"/>&amp;myblog=1&amp;page=1</xsl:attribute>
										<xsl:value-of select="name"/>
									</a>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
			</td>
			</tr>
			
			
		</table>
    </xsl:template>

</xsl:stylesheet> 
