<?xml version="1.0" encoding="UTF-8" ?>
<!--
////////////////////////////////////////////////
//Blogxter Default StyleSheet
//
//Formats both full blog and individual entries.
//Formats comments and trackbacks.
//
//Only do layout here. Use CSS for colour, Font etc.
//
//(C) 2003, 1060 Research Ltd
///////////////////////////////////////////////
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	<!--IMPORTANT: Must include the library templates-->
	<xsl:include href="/www/view/lnf/xsl/lib.xsl"/>
	
	<xsl:param name="param"/>
	
    <xsl:template match="/blog">
		<div xmlns:xrl="http://1060.org/xrl">
			<link type="text/css" rel="stylesheet" href="xrl:css_default_blog_lnf" xrl:resolve="href"/>
			<!--
			/////////////////////////
			//1. The Preliminaries
			/////////////////////////
			-->
			<!--Title-->
			<div id="title" style="display:none;"><xsl:value-of select="meta/results/row/name"/></div>
			<!--
			///////////////////////
			//User CSS substitution
			///////////////////////
			-->
			<div id="replacebystyle"/>  <!--IMPORTANT: This must be included so that it can be replaced by a user CSS style-->
			
			<!--
			//////////////
			//PopUp Script
			//////////////
			-->
			<xsl:call-template name="popupScript"/>  <!--This is required for the popup comment window-->

			<!--A variable to hold the total number of entries -->
			<xsl:variable name="countmain" select="meta/results/row/count"/>
			
			<!--
			/////////////////////
			//2. The main layout
			/////////////////////
			-->
			<table width="100%" cellspacing="0" cellpadding="0">
				<tr>
					<td width="2%" class="blog-gutter">
					</td>
					<td class="background">
						<!--
						/////////////////////
						//Site Navigation Tab
						/////////////////////
						-->
						<div xmlns:xrl="http://1060.org/xrl" class="blog-gutter">
							<a href="xrl:home" xrl:resolve="href"><img name="home" border="0" src="[[xrl:menu_img_service]]?value=home&amp;background=%239ca1e1" xrl:resolve="src" onmouseover="highlight('home')" onmouseout="lowlight('home')"/></a>
							<a href="xrl:myblog" xrl:resolve="href"><img name="login" border="0" src="[[xrl:menu_img_service]]?value=myblogs&amp;background=%239ca1e1" xrl:resolve="src" onmouseover="highlight('login')" onmouseout="lowlight('login')"/></a>
						</div>
						
						<!--
						///////////////////
						//BLOG TITLE BAR
						///////////////////
						-->
						<table style="margin: 2px; width: 100%; background: url('[[xrl:default_blog_title_img]]');  background-repeat: no-repeat; background-color: white; vertical-align: bottom; " xrl:resolve="style">
						<tr>
							<td >
									<div class="blog-title">
										<xsl:value-of select="meta/results/row/name"/>
									</div>
									<div class="blog-sub-title">
										<xsl:value-of select="meta/results/row/descr"/>
									</div>
							</td>
							<td style="text-align: right;">
							<table style="height: 96px;" align="right"><tr>
							<xsl:choose>
							<xsl:when test="$param/nvp/full">
									<td style="vertical-align: bottom; ">
										<xsl:variable name="totalpages" select="stats-blog/results/row/total_entries div $countmain"/>
										<table cellpadding="0" cellspacing="0">
											<xsl:call-template name="pages">
											<xsl:with-param name="count" select="1"/>
											<xsl:with-param name="count2" select="1"/>
											<xsl:with-param name="totalpages" select="$totalpages"/>
											<xsl:with-param name="countmain" select="$countmain"/>
											</xsl:call-template>
										</table>
									</td>
									<td style="vertical-align: bottom; ">
										<xsl:variable name="page_low" select="($param/nvp/page - 1) * $countmain +1"/>
										<xsl:variable name="page_high" select="($countmain) * ($param/nvp/page)"/>
										<xsl:variable name="page_max" select="stats-blog/results/row/total_entries"/>
										( Entry <xsl:value-of select="$page_low"/>
										<xsl:choose>
											<xsl:when test="$page_low &gt;= $page_high or $page_low=$page_max"/>
											<xsl:when test="$page_high &lt; $page_max">
												- <xsl:value-of select="$page_high"/>
											</xsl:when>
											<xsl:otherwise>
												- <xsl:value-of select="$page_max"/>
											</xsl:otherwise>
										</xsl:choose>
										of <xsl:value-of select="$page_max"/> )
									</td>
							</xsl:when>
							<xsl:otherwise>
								<td/>
							</xsl:otherwise>
							</xsl:choose>
							</tr></table>
							</td>
						</tr></table>

						<!--
						/////////////////////
						//3. The Entries
						/////////////////////
						-->
						<table cellpadding="0" cellspacing="0" width="100%">
							<xsl:apply-templates select="entries/results/row"/>
						</table>
						<!--
						//////////////////
						//4. The comments
						//////////////////
						-->
						<xsl:if test="$param/nvp/entry and /blog/settings/results/row[setting='COMMENTS']/value > 0">
							<!--
							////////////////
							//Comments Title
							////////////////
							-->
							<table>
								<tr>
									<td>
										<h2>Comments</h2>
										<div>
											<a xrl:resolve="href">	
												<xsl:attribute name="href">javascript:popUp('[[xrl:blog_start_comment]]?publicid=<xsl:value-of select="/blog/entries/results/row/publicid"/>')</xsl:attribute>
												new comment thread
											</a>
										</div>
									</td>
								</tr>
							</table>
							<!--
							//////////////////////
							//Process the comments
							//////////////////////
							-->
							<table cellpadding="0" cellspacing="0" width="100%">
								<tr><td width="50"/><td/></tr>
								<xsl:apply-templates select="comments/results" mode="comment"/>
							</table>
						</xsl:if>
						<!--
						////////////////////
						//5. The trackbacks
						////////////////////
						-->
						<xsl:if test="$param/nvp/entry and /blog/settings/results/row[setting='TRACKBACKS']/value > 0">
							<!--
							//////////////////
							//Trackbacks Title
							//////////////////
							-->
							<table>
								<tr>
									<td>
										<h2>Trackbacks</h2>
										<div style="font-style: italic; ">Trackback Address: <xsl:value-of select="/blog/meta/results/row/hostname"/>blogxter/trackback/<xsl:value-of select="/blog/entries/results/row/publicid"/></div>
									</td>
								</tr>
							</table>
							<!--
							////////////////////////
							//Process the trackbacks
							////////////////////////
							-->
							<table cellpadding="0" cellspacing="0" width="100%">
								<tr><td width="50"/><td/></tr>
								<xsl:apply-templates select="trackbacks/results" mode="trackback"/>
							</table>
						</xsl:if>
						<!--
						//////////////////////
						//6. Trackback Metadata - must include this for trackback clients to discover trackback interface
						//////////////////////
						-->
						<xsl:call-template name="trackback"/>
						
						<!--
						///////////////////////
						//7. Navigation and RSS
						///////////////////////
						-->
						<xsl:if test="$param/nvp/entry">
							<form>
								<input type="button" value="Back" onclick="history.back()"/>
							</form>
						</xsl:if>
						<!--RSS Link-->
						<div style="margin: 10px; float: right;">
							<a xrl:resolve="href">
								<xsl:attribute name="href">[[xrl:rss]]?blogid=<xsl:value-of select="meta/results/row/id"/></xsl:attribute>
								<img src="xrl:img_RSS_icon" xrl:resolve="src" border="0"/>
							</a>
						</div>
					</td>
					<td width="2%" class="blog-gutter"/>
				</tr>
			</table>
			<table width="100%">
				<tr><td width="100%" class="footer">(C) 2003,2004 1060 Research Limited<br/>1060 Registered Trademark and NetKernel Trademark of 1060 Research Limited</td>
					<td class="footer" width="0%" valign="top"><a href="http://www.1060research.com/"><img border="0" src="xrl:img_poweredby_blog" xrl:resolve="src" /></a></td>
				</tr>
			</table>
		</div>
    </xsl:template>
	
	<!--
	///////////////////////
	//Process Each Entry
	///////////////////////
	-->
	<xsl:template match="row">
		<!--
		/////////////////////
		//The Entry Title Bar
		/////////////////////
		-->
		<tr><td width="100%">
			<table class="entry">
				<tr>
					<td>
						<div class="dateblock">
						<span class="datenum"><xsl:value-of select="dateDayOfMonth"/></span>
						<span><xsl:value-of select="substring(dateMonthName,1,3)"/></span><br/>
						<span><xsl:value-of select="substring(dateDayName,1,3)"/></span>
						<span><xsl:value-of select="dateYear"/></span>
						</div>
					</td>
					<td>
						<div class="entry-title"><xsl:value-of select="title"/></div>
						<xsl:copy-of select="entry"/>
					</td>
				</tr>
			</table>
		</td>
		<!--
		/////////////////////
		Inc;ude Polls Service
		/////////////////////
		-->
		<xrl:include href="xrl:blog_poll_publish">
			<nvp>
				<publicid><xsl:value-of select="publicid"/></publicid>
			</nvp>
		</xrl:include>
		</tr>
		<!--
		////////////////////////
		//The stats and metadata
		////////////////////////
		-->
		<tr>
			<td class="entry-meta">
				<!--
				///////////////////
				//The posted by bar
				///////////////////
				-->
				<span>
				Posted by <xsl:value-of select="userid"/> at
					<xsl:call-template name="addzero">
						<xsl:with-param name="n" select="timeHour"/>
					</xsl:call-template>:<xsl:call-template name="addzero">
						<xsl:with-param name="n" select="timeMinute"/>
					</xsl:call-template>
				</span>
				
				<!--
				////////////////////////////////////
				//The comment/trackback notification
				////////////////////////////////////
				-->
				<xsl:if test="$param/nvp/full">
					<xsl:variable name="id" select="id"/>
					<span style="margin-left: 4px;">
						<a xrl:resolve="href"><xsl:attribute name="href">[[xrl:publish_entry]]?publicid=<xsl:value-of select="publicid"/>&amp;token=<xsl:value-of select="$param/nvp/token"/></xsl:attribute>comments</a>
						[
						<xsl:variable name="count" select="/blog/stats-comment/results/row[id=$id]/tc"/>
						<xsl:choose>
							<xsl:when test="$count">
								<xsl:value-of select="$count"/>
							</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
						]
						<a xrl:resolve="href"><xsl:attribute name="href">[[xrl:publish_entry]]?publicid=<xsl:value-of select="publicid"/>&amp;token=<xsl:value-of select="$param/nvp/token"/></xsl:attribute>trackbacks</a>
						[
						<xsl:variable name="count" select="/blog/stats-trackback/results/row[id=$id]/tt"/>
						<xsl:choose>
							<xsl:when test="$count">
								<xsl:value-of select="$count"/>
							</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
						] 
					</span>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>
	
	
	
	<!--
	/////////////////////////////////
	//Process comments with threading
	/////////////////////////////////
	-->
		<!--
		//////////////////////////////////////////////
		//Manchian Grouping Key for threading comments
		//////////////////////////////////////////////
		-->
		<xsl:key name="threaded-comments" match="row" use="title"/>
	<xsl:template match="results" mode="comment">
		<xsl:for-each select="row[count(. | key('threaded-comments', title)[1]) = 1]">
			<tr>
				<td/>
				<td>
					<div>
						<span class="comment-title"><xsl:value-of select="title"/></span>
						<a xrl:resolve="href"><xsl:attribute name="href">javascript:popUp('[[xrl:blog_start_thread_comment]]?title=<xsl:value-of select="title"/>&amp;publicid=<xsl:value-of select="/blog/entries/results/row/publicid"/>')</xsl:attribute>reply to this thread</a>
					</div>	
					<xsl:for-each select="key('threaded-comments', title)">
						<div class="comment-entry">
							<div class="comment-meta">
						On		<xsl:value-of select="concat(dateDayOfMonth,' ')"/> <xsl:value-of select="concat(dateMonthName,' ')"/> <xsl:value-of select="dateYear"/>
						at		<xsl:call-template name="addzero">
								<xsl:with-param name="n" select="timeHour"/>
								</xsl:call-template>:
								<xsl:call-template name="addzero">
									<xsl:with-param name="n" select="timeMinute"/>
								</xsl:call-template>

								<span class="comment-title"><xsl:value-of select="concat(' ',author)"/></span > commented: 
							</div>
							<div class="comment-text">
								<xsl:copy-of select="comment/*"/>
							</div>
						</div>
					</xsl:for-each>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>

	<!--
	/////////////////////////////////
	//Process Trackbacks
	/////////////////////////////////
	-->
	<xsl:template match="results" mode="trackback">
		<xsl:for-each select="row">
			<tr>
				<td/>
				<td class="comment-entry">
					<div class="comment-title">
						<xsl:value-of select="title"/>
					</div>	
					<div>
						<div class="comment-meta">
					On		<xsl:value-of select="concat(dateDayName, ' ')"/>
							<xsl:value-of select="concat(dateDayOfMonth,' ')"/>
							<xsl:value-of select="concat(dateMonthName, ' ')"/>
							<xsl:value-of select="dateYear"/>
					at		<xsl:call-template name="addzero">
							<xsl:with-param name="n" select="timeHour"/>
							</xsl:call-template>:
							<xsl:call-template name="addzero">
								<xsl:with-param name="n" select="timeMinute"/>
							</xsl:call-template>
							
							<span style="margin-left: 3px;">
								<a>
								<xsl:attribute name="href"><xsl:value-of select="URL"/></xsl:attribute>
									<xsl:value-of select="blogname"/>
								</a>
							</span> 
							posted
						</div>
						<div class="comment-text">
							<xsl:copy-of select="excerpt"/>
						</div>
					</div>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	
	
</xsl:stylesheet> 
