<?xml version="1.0" encoding="UTF-8" ?>
<!--
////////////////////////////////////////////////
//Blogxter StyleSheet Library
//
//(C) 2003, 1060 Research Ltd
///////////////////////////////////////////////
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>
		
	<!--
	//////////////////////////////////////////////
	//Utility to add Zero to a number less than 10
	//////////////////////////////////////////////
	-->
	<xsl:template name="addzero">
		<xsl:param name="n"/>
		<xsl:if test="$n &lt; 10">0</xsl:if><xsl:value-of select="$n"/>
	</xsl:template>
	
	
	<!--
	//////////////////////////////////////////////
	//Pagination Display
	//////////////////////////////////////////////
	-->
	<xsl:template name="pages">
		<xsl:param name="count"/>
		<xsl:param name="totalpages"/>
		<xsl:param name="count2"/>
		<xsl:param name="countmain"/>
		<tr>
			<xsl:choose>
				<xsl:when test="$count=1">
					<td>Page</td>
				</xsl:when>
				<xsl:otherwise><td/></xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$totalpages &lt; 20">
					<xsl:call-template name="pagecount">
						<xsl:with-param name="count" select="$count"/>
						<xsl:with-param name="count2" select="$count2"/>
						<xsl:with-param name="totalpages" select="$totalpages"/>
						<xsl:with-param name="countmain" select="$countmain"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="pagecount">
						<xsl:with-param name="count" select="$count"/>
						<xsl:with-param name="count2" select="$count2"/>
						<xsl:with-param name="totalpages" select="20"/>
						<xsl:with-param name="countmain" select="$countmain"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
	</xsl:template>
	
	<!--Page Indicator-->	
	<xsl:template name="pagecount">
		<xsl:param name="count"/>
		<xsl:param name="count2"/>
		<xsl:param name="totalpages"/>
		<xsl:param name="countmain"/>
		
		<xsl:choose>
			<xsl:when test="($count2 + ($count - 1)*$countmain)-1 &lt; $totalpages and ($count2 -1) &lt; $countmain">
			<td align="center">
			<span style="margin-right: 1px;"> 
				<xsl:choose>
					<xsl:when test="$count2 + ($count - 1)*$countmain = $param/nvp/page">
						<xsl:attribute name="class">blog-publish-page-indicator-selected</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="class">blog-publish-page-indicator</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<a>
					<xsl:choose>
						<xsl:when test="$param/nvp/myblog">
							<xsl:attribute name="href">publish?blogid=<xsl:value-of select="/blog/meta/results/row/id"/>&amp;page=<xsl:value-of select="$count2+($count - 1)*$countmain "/>&amp;myblog=true</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="href"><xsl:value-of select="/blog/meta/results/row/id"/>?page=<xsl:value-of select="$count2+($count - 1)*$countmain "/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="$count2+($count - 1)*$countmain"/>
				</a>
			</span>
			</td>
			<xsl:call-template name="pagecount">
					<xsl:with-param name="count" select="$count"/>
					<xsl:with-param name="count2" select="$count2+1"/>
					<xsl:with-param name="totalpages" select="$totalpages"/>
					<xsl:with-param name="countmain" select="$countmain"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="($count2 -1) = $countmain">
				<xsl:call-template name="pagecount">
					<xsl:with-param name="count" select="$count+1"/>
					<xsl:with-param name="count2" select="1"/>
					<xsl:with-param name="totalpages" select="$totalpages"/>
					<xsl:with-param name="countmain" select="$countmain"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
		
	</xsl:template>
	
	<!--
	//////////////////////////////////////////////
	//Trackback Metadata
	//////////////////////////////////////////////
	-->
	<xsl:template name="trackback">
		<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
				 xmlns:dc="http://purl.org/dc/elements/1.1/"
				 xmlns:trackback="http://madskills.com/public/xml/rss/module/trackback/">
				<rdf:Description>
					<xsl:attribute name="dc:about"><xsl:value-of select="/blog/meta/results/row/hostname"/>blogxter/entry?publicid=<xsl:value-of select="/blog/entries/results/row/publicid"/></xsl:attribute>
					<xsl:attribute name="dc:title"><xsl:value-of select="/blog/entries/results/row/title"/></xsl:attribute>
					<xsl:attribute name="dc:identifier"><xsl:value-of select="/blog/meta/results/row/hostname"/>blogxter/entry?publicid=<xsl:value-of select="/blog/entries/results/row/publicid"/></xsl:attribute>
					<xsl:attribute name="trackback:ping"><xsl:value-of select="/blog/meta/results/row/hostname"/>blogxter/trackback/<xsl:value-of select="/blog/entries/results/row/publicid"/></xsl:attribute>
				</rdf:Description>
		</rdf:RDF>
	</xsl:template>
	
	<!--
	//////////////////////////////////////////////
	//Popup Javascript
	//////////////////////////////////////////////
	-->
	<xsl:template name="popupScript">
		<script language="JavaScript">
				<xsl:comment>
				function popUp(URL) {
				day = new Date();
				id = day.getTime();
				eval("page" + id + " = window.open(URL, '" + id + "', 'toolbar=0,scrollbars=0,location=0,statusbar=0,menubar=0,resizable=1,width=400,height=560');");
				}	
				</xsl:comment>
		</script>
	</xsl:template>
	
</xsl:stylesheet> 
