<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_address.xsl
    Created on : 06 January 2004, 16:24
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/">
        <div>
			<xsl:choose>
				<xsl:when test="$param/nvp/letter">
					<div style="font-size: 30px;"><xsl:value-of select="translate($param/nvp/letter, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/></div>
				</xsl:when>
				<xsl:otherwise>
					<div style="font-size: 30px;"><xsl:value-of select="$param/nvp/search"/></div>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
		<div style="font-size: 15px; margin-left: 5px; margin-top: 5px;">No Entries</div>
	</xsl:template>
	
	<xsl:template match="results">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="row">
		<table style="margin-top: 15px; margin-bottom: 15px;" cellspacing="0" cellpadding="0">
		<tr>
			<td>
				<table style="padding: 5px; margin-bottom:5px;" cellspacing="0" cellpadding="0">
					<tr >
					<td colspan="10">
						<table style="padding-right: 5px" cellspacing="0" cellpadding="0">
							<tr>
								<td style="padding-right: 5px;"><xsl:value-of select="LASTNAME"/></td><td><xsl:value-of select="FIRSTNAME"/></td>
							</tr>
						</table>
					</td>
					</tr>
					<tr>
						<td valign="top" width="200">
						<table style="padding-right: 5px" cellspacing="0" cellpadding="0">
							<tr>
							<td><xsl:value-of select="ADD1"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="ADD2"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="ADD3"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="ADD4"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="REGION"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="COUNTRY"/></td>
							</tr>
						</table>
						</td>
						<td valign="top" width="200">
						<table style="padding-right: 5px" cellspacing="0" cellpadding="0">
							<tr>
							<td><xsl:value-of select="PHONE1"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="PHONE2"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="PHONE3"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="FAX"/></td>
							</tr>
						</table>
						</td>
					</tr>
					<tr>
						<td valign="top">
						<table style="padding-right: 5px" cellspacing="0" cellpadding="0">
							<tr>
							<td><a>
								<xsl:attribute name="href">
									mailto:<xsl:value-of select="EMAIL1"/>
								</xsl:attribute>
								<xsl:value-of select="EMAIL1"/>
								</a>
							</td>
							</tr>
							<tr>
							<td><a>
								<xsl:attribute name="href">
									mailto:<xsl:value-of select="EMAIL2"/>
								</xsl:attribute>
								<xsl:value-of select="EMAIL2"/>
								</a>
							</td>
							</tr>
							<tr>
							<td><a>
								<xsl:attribute name="href">
									mailto:<xsl:value-of select="EMAIL3"/>
								</xsl:attribute>
								<xsl:value-of select="EMAIL3"/>
								</a>
							</td>
							</tr>
						</table>
						</td>
						<td valign="top">
						<table style="padding-right: 5px" cellspacing="0" cellpadding="0">
							<tr>
							<td><a>
								<xsl:attribute name="href">
									<xsl:value-of select="WEB1"/>
								</xsl:attribute>
								<xsl:value-of select="WEB1"/>
								</a>
							</td>
							</tr>
							<tr>
							<td><a>
								<xsl:attribute name="href">
									<xsl:value-of select="WEB2"/>
								</xsl:attribute>
								<xsl:value-of select="WEB2"/>
								</a>
							</td>
							</tr>
						</table>
						</td>
					</tr>
					<tr>
						<td colspan="10" style="font-style: italic;"><xsl:value-of select="NOTES"/></td>
					</tr>
					<tr>
						<td colspan="10">
							<div style="float:right; font-size: 8px;">
							<a>
								<xsl:attribute name="href">
									edit?id=<xsl:value-of select="ID"/>
								</xsl:attribute>
								edit
							</a>
							|
							<a>
								<xsl:attribute name="href">
									delete?id=<xsl:value-of select="ID"/>
								</xsl:attribute>
								delete
							</a>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		</table>
	</xsl:template>
</xsl:stylesheet> 
