<?xml version="1.0" encoding="UTF-8" ?>

<!--<comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Public License v1.0 - You may modifiy and
		use this software in any manner provided that any derivative work
		is licensed in compliance with the terms of the 1060 Public License.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/">

<html>
	<head >
		<title>Address Book Installer</title>
		<link href="/introspect/pub/css_introspect.css" rel="stylesheet" type="text/css"  />
	</head>
	<body>
		<table width="100%">
		<tr>
			<td colspan="2" style="border-bottom: 1px solid silver; padding-bottom: 5px;">
			<!--<img src="xrl:img_blogxter" xrl:resolve="src" valign="middle"/>-->
			<div style="font-size: 75px;">
			Address Book
			</div>
			<div style="font-size: 25px;">
			A simple example of a database backed Web-application
			</div>
			<span style="float: right; font-size: 25px; color: d1d1c0;">Installer</span>
			</td>
		</tr>
		</table>
		<h3>JDBC Installation Notes</h3>
		<p>
		This application uses the <a href="http://hsqldb.sourceforge.net/">HSQLDB</a> embedded Java SQL RDBMS shipped as part of mod_db version 1.1.0.
		</p>
		<p>
		</p>
		<xsl:if test="$param">
			<table>
					<tr>
						<td bgcolor="red">
						<h2>Error</h2>
						<div style="color: ffffff;">
						<xsl:value-of select="$param/descendant::ex[position()=last()]/message"/>
						</div>
						<div>
						Please check your database permissions.  The DB Admin account you use must have remote access
						and GRANT permissions.  Also make sure you have a MySQL JDBC driver installed in mod_db/lib/.
						</div>
						</td>
					</tr>
			</table>
		</xsl:if>
				
		<form action="http://localhost:1060/ep+name@app_address_book_installer_start" method="post">
			<table>
				<tr>
					<td align="left" height="30" valign="bottom">
					<h3>Database Installation Directory</h3>
					<p>The directory in which the HSQLDB database files will be located</p>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>Directory 
							<input name="directory" style="width: 300px;">
								<xsl:attribute name="value"><xsl:value-of select="/nvp/directory"/></xsl:attribute>
							</input>
					</label>
					</td>
				</tr>
			</table>
			
		</form>
	</body>
	
</html>

    </xsl:template>

</xsl:stylesheet> 
