<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_address.xsl
    Created on : 06 January 2004, 16:24
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/">
        <div>
			<xsl:choose>
				<xsl:when test="$param/nvp/letter">
					<div style="font-size: 30px;"><xsl:value-of select="translate($param/nvp/letter, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/></div>
				</xsl:when>
				<xsl:otherwise>
					<div style="font-size: 30px;"><xsl:value-of select="$param/nvp/search"/></div>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
		<div style="font-size: 15px; margin-left: 5px; margin-top: 5px;">No Entries</div>
	</xsl:template>
	
	<xsl:template match="results">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="row">
		<table style="margin-top: 15px; margin-bottom: 15px;" cellspacing="0" cellpadding="0">
		<tr>
			<td>
				<table style="padding: 5px; margin-bottom:5px;" cellspacing="0" cellpadding="0">
					<tr >
					<td colspan="10">
						<table style="padding-right: 5px" cellspacing="0" cellpadding="0">
							<tr>
								<td style="padding-right: 5px;"><xsl:value-of select="lastname"/></td><td><xsl:value-of select="firstname"/></td>
							</tr>
						</table>
					</td>
					</tr>
					<tr>
						<td valign="top" width="200">
						<table style="padding-right: 5px" cellspacing="0" cellpadding="0">
							<tr>
							<td><xsl:value-of select="add1"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="add2"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="add3"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="add4"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="region"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="country"/></td>
							</tr>
						</table>
						</td>
						<td valign="top" width="200">
						<table style="padding-right: 5px" cellspacing="0" cellpadding="0">
							<tr>
							<td><xsl:value-of select="phone1"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="phone2"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="phone3"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="fax"/></td>
							</tr>
						</table>
						</td>
					</tr>
					<tr>
						<td valign="top">
						<table style="padding-right: 5px" cellspacing="0" cellpadding="0">
							<tr>
							<td><xsl:value-of select="email1"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="email2"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="email3"/></td>
							</tr>
						</table>
						</td>
						<td valign="top">
						<table style="padding-right: 5px" cellspacing="0" cellpadding="0">
							<tr>
							<td><xsl:value-of select="web1"/></td>
							</tr>
							<tr>
							<td><xsl:value-of select="web2"/></td>
							</tr>
						</table>
						</td>
					</tr>
					<tr>
						<td colspan="10" style="font-style: italic;"><xsl:value-of select="notes"/></td>
					</tr>
				</table>
			</td>
		</tr>
		</table>
	</xsl:template>
</xsl:stylesheet> 
